/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.mtls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.node.AddressToHostname;
import io.airlift.security.cert.CertificateBuilder;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public final class AutomaticMtls {
    private AutomaticMtls() {
    }

    @CanIgnoreReturnValue
    public static X509Certificate addCertificateAndKeyForCurrentNode(String sharedSecret, String commonName, KeyStore keyStore, String keyStorePassword) {
        try {
            List<InetAddress> allLocalIpAddresses = AutomaticMtls.getAllLocalIpAddresses();
            List ipAddressMappedNames = (List)allLocalIpAddresses.stream().map(AddressToHostname::encodeAddressAsHostname).collect(ImmutableList.toImmutableList());
            X509Certificate certificate = AutomaticMtls.certificateBuilder(sharedSecret, commonName).addSanIpAddresses(allLocalIpAddresses).addSanDnsNames(ipAddressMappedNames).buildSelfSigned();
            return AutomaticMtls.addCertificateToKeyStore(sharedSecret, commonName, certificate, keyStore, keyStorePassword);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static X509Certificate addCertificateToKeyStore(String sharedSecret, String commonName, X509Certificate certificate, KeyStore keyStore, String keyStorePassword) {
        try {
            KeyPair keyPair = AutomaticMtls.fromSharedSecret(sharedSecret);
            char[] password = keyStorePassword == null ? new char[]{} : keyStorePassword.toCharArray();
            keyStore.setKeyEntry(commonName, keyPair.getPrivate(), password, new Certificate[]{certificate});
            return certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addClientTrust(String sharedSecret, KeyStore keyStore, String commonName) {
        try {
            X509Certificate certificateServer = AutomaticMtls.certificateBuilder(sharedSecret, commonName).buildSelfSigned();
            keyStore.setCertificateEntry(commonName, certificateServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static X509TrustManager createTrustManager(String sharedSecret, String commonName) {
        try {
            KeyPair keyPair = AutomaticMtls.fromSharedSecret(sharedSecret);
            return new SingleCertificateTrustManager(keyPair.getPublic(), commonName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext createSSLContext(String sharedSecret, String commonName, KeyStore keyStore, String keyManagerPassword) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyManagerPassword.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{AutomaticMtls.createTrustManager(sharedSecret, commonName)}, null);
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<InetAddress> getAllLocalIpAddresses() throws SocketException {
        ImmutableList.Builder list = ImmutableList.builder();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isMulticastAddress()) continue;
                list.add((Object)address);
            }
        }
        return list.build();
    }

    private static KeyPair fromSharedSecret(String sharedSecret) {
        try {
            byte[] seed = sharedSecret.getBytes(StandardCharsets.UTF_8);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(seed);
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(new ECGenParameterSpec("secp256r1"), secureRandom);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static CertificateBuilder certificateBuilder(String sharedSecret, String commonName) {
        KeyPair keyPair = AutomaticMtls.fromSharedSecret(sharedSecret);
        LocalDate notBefore = LocalDate.now();
        LocalDate notAfter = notBefore.plusYears(10L);
        X500Principal subject = AutomaticMtls.certificateSubject(commonName);
        return CertificateBuilder.certificateBuilder().setKeyPair(keyPair).setSerialNumber(System.currentTimeMillis()).setIssuer(subject).setNotBefore(notBefore).setNotAfter(notAfter).setSubject(subject);
    }

    private static X500Principal certificateSubject(String commonName) {
        return new X500Principal("CN=" + commonName);
    }

    public static KeyStore inMemoryKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create in-memory keystore", e);
        }
    }

    private record SingleCertificateTrustManager(PublicKey trustedPublicKey, String commonName) implements X509TrustManager
    {
        private SingleCertificateTrustManager(PublicKey trustedPublicKey, String commonName) {
            this.trustedPublicKey = Objects.requireNonNull(trustedPublicKey, "trustedPublicKey is null");
            this.commonName = Objects.requireNonNull(commonName, "commonName is null");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            this.check(chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            this.check(chain);
        }

        private void check(X509Certificate[] chain) {
            X500Principal expectedSubject;
            if (chain == null || chain.length == 0) {
                throw new SecurityException("Empty certificate chain");
            }
            if (chain.length > 1) {
                throw new SecurityException("Certificate chain must contain only one certificate");
            }
            X509Certificate certificate = chain[0];
            PublicKey peerKey = certificate.getPublicKey();
            if (!Arrays.equals(peerKey.getEncoded(), this.trustedPublicKey.getEncoded())) {
                throw new SecurityException("Peer cert public key doesn't match trusted key");
            }
            X500Principal peerSubject = certificate.getSubjectX500Principal();
            if (!peerSubject.equals(expectedSubject = AutomaticMtls.certificateSubject(this.commonName))) {
                throw new SecurityException("Peer certificate subject '%s' does not match expected subject: '%s'".formatted(peerSubject, expectedSubject));
            }
            X500Principal peerIssuer = certificate.getIssuerX500Principal();
            if (!peerIssuer.equals(expectedSubject)) {
                throw new SecurityException("Peer certificate issuer '%s' does not match expected subject: '%s'".formatted(peerIssuer, expectedSubject));
            }
            Instant now = Instant.now();
            if (certificate.getNotBefore().toInstant().isAfter(now)) {
                throw new SecurityException("Peer certificate is not valid yet (notBefore: %s)".formatted(certificate.getNotBefore()));
            }
            if (certificate.getNotAfter().toInstant().isBefore(now)) {
                throw new SecurityException("Peer certificate has expired (notAfter: %s)".formatted(certificate.getNotAfter()));
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

