/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.primitives.UnsignedBytes;
import io.airlift.slice.ByteArrays;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestByteArrays {
    @Test
    public void testReading() {
        Assert.assertEquals((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        byte[] bytes = new byte[10];
        Slice slice = Slices.wrappedBuffer((byte[])bytes);
        slice.setInt(0, -559038737);
        slice.setInt(4, -889275714);
        TestByteArrays.assertBytes(slice.getBytes(), 239, 190, 173, 222, 190, 186, 254, 202, 0, 0);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)0), (short)-16657);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)1), (short)-21058);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)2), (short)-8531);
        Assert.assertEquals((short)ByteArrays.getShort((byte[])bytes, (int)3), (short)-16674);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)0), (int)-559038737);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)1), (int)-1092702786);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)2), (int)-1161896275);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)3), (int)-21315874);
        Assert.assertEquals((int)ByteArrays.getInt((byte[])bytes, (int)4), (int)-889275714);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)0), (long)-3819410105021120785L);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)1), (long)57138023315189182L);
        Assert.assertEquals((long)ByteArrays.getLong((byte[])bytes, (int)2), (long)223195403574957L);
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)0)), (Object)Float.valueOf(Float.intBitsToFloat(-559038737)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)1)), (Object)Float.valueOf(Float.intBitsToFloat(-1092702786)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)2)), (Object)Float.valueOf(Float.intBitsToFloat(-1161896275)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)3)), (Object)Float.valueOf(Float.intBitsToFloat(-21315874)));
        Assert.assertEquals((Object)Float.valueOf(ByteArrays.getFloat((byte[])bytes, (int)4)), (Object)Float.valueOf(Float.intBitsToFloat(-889275714)));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)0), (Object)Double.longBitsToDouble(-3819410105021120785L));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)1), (Object)Double.longBitsToDouble(57138023315189182L));
        Assert.assertEquals((Object)ByteArrays.getDouble((byte[])bytes, (int)2), (Object)Double.longBitsToDouble(223195403574957L));
    }

    @Test
    public void testWriting() {
        Assert.assertEquals((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        byte[] bytes = new byte[10];
        TestByteArrays.zeroFill(bytes);
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setShort((byte[])bytes, (int)0, (short)-16657);
        TestByteArrays.assertBytes(bytes, 239, 190, 0, 0, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setShort((byte[])bytes, (int)1, (short)-16657);
        TestByteArrays.assertBytes(bytes, 0, 239, 190, 0, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setShort((byte[])bytes, (int)2, (short)-16657);
        TestByteArrays.assertBytes(bytes, 0, 0, 239, 190, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setShort((byte[])bytes, (int)3, (short)-16657);
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 239, 190, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setShort((byte[])bytes, (int)4, (short)-16657);
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 0, 239, 190, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setInt((byte[])bytes, (int)0, (int)-559038737);
        TestByteArrays.assertBytes(bytes, 239, 190, 173, 222, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setInt((byte[])bytes, (int)1, (int)-559038737);
        TestByteArrays.assertBytes(bytes, 0, 239, 190, 173, 222, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setInt((byte[])bytes, (int)2, (int)-559038737);
        TestByteArrays.assertBytes(bytes, 0, 0, 239, 190, 173, 222, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setInt((byte[])bytes, (int)3, (int)-559038737);
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 239, 190, 173, 222, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setInt((byte[])bytes, (int)4, (int)-559038737);
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 0, 239, 190, 173, 222, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setLong((byte[])bytes, (int)0, (long)-3819410105021120785L);
        TestByteArrays.assertBytes(bytes, 239, 190, 173, 222, 190, 186, 254, 202, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setLong((byte[])bytes, (int)1, (long)-3819410105021120785L);
        TestByteArrays.assertBytes(bytes, 0, 239, 190, 173, 222, 190, 186, 254, 202, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setLong((byte[])bytes, (int)2, (long)-3819410105021120785L);
        TestByteArrays.assertBytes(bytes, 0, 0, 239, 190, 173, 222, 190, 186, 254, 202);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setFloat((byte[])bytes, (int)0, (float)Float.intBitsToFloat(-559038737));
        TestByteArrays.assertBytes(bytes, 239, 190, 173, 222, 0, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setFloat((byte[])bytes, (int)1, (float)Float.intBitsToFloat(-559038737));
        TestByteArrays.assertBytes(bytes, 0, 239, 190, 173, 222, 0, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setFloat((byte[])bytes, (int)2, (float)Float.intBitsToFloat(-559038737));
        TestByteArrays.assertBytes(bytes, 0, 0, 239, 190, 173, 222, 0, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setFloat((byte[])bytes, (int)3, (float)Float.intBitsToFloat(-559038737));
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 239, 190, 173, 222, 0, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setFloat((byte[])bytes, (int)4, (float)Float.intBitsToFloat(-559038737));
        TestByteArrays.assertBytes(bytes, 0, 0, 0, 0, 239, 190, 173, 222, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setDouble((byte[])bytes, (int)0, (double)Double.longBitsToDouble(-3819410105021120785L));
        TestByteArrays.assertBytes(bytes, 239, 190, 173, 222, 190, 186, 254, 202, 0, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setDouble((byte[])bytes, (int)1, (double)Double.longBitsToDouble(-3819410105021120785L));
        TestByteArrays.assertBytes(bytes, 0, 239, 190, 173, 222, 190, 186, 254, 202, 0);
        TestByteArrays.zeroFill(bytes);
        ByteArrays.setDouble((byte[])bytes, (int)2, (double)Double.longBitsToDouble(-3819410105021120785L));
        TestByteArrays.assertBytes(bytes, 0, 0, 239, 190, 173, 222, 190, 186, 254, 202);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingShortBounds() {
        ByteArrays.getShort((byte[])new byte[3], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingIntBounds() {
        ByteArrays.getInt((byte[])new byte[5], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingLongBounds() {
        ByteArrays.getLong((byte[])new byte[9], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingFloatBounds() {
        ByteArrays.getFloat((byte[])new byte[5], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testReadingDoubleBounds() {
        ByteArrays.getDouble((byte[])new byte[9], (int)2);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testWritingShortBounds() {
        ByteArrays.setShort((byte[])new byte[3], (int)2, (short)123);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testWritingIntBounds() {
        ByteArrays.setInt((byte[])new byte[5], (int)2, (int)123);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testWritingLongBounds() {
        ByteArrays.setLong((byte[])new byte[9], (int)2, (long)123L);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testWritingFloatBounds() {
        ByteArrays.setFloat((byte[])new byte[5], (int)2, (float)123.0f);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testWritingDoubleBounds() {
        ByteArrays.setDouble((byte[])new byte[9], (int)2, (double)123.0);
    }

    private static void assertBytes(byte[] actual, int ... expected) {
        Assert.assertEquals((int)actual.length, (int)expected.length);
        byte[] array = new byte[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            array[i] = UnsignedBytes.checkedCast((long)expected[i]);
        }
        Assert.assertEquals((byte[])actual, (byte[])array);
    }

    private static void zeroFill(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }
}

