/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMurmur3Hash128 {
    @Test(invocationCount=100)
    public void testLessThan16Bytes() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(ThreadLocalRandom.current().nextInt(16));
        HashCode expected = Hashing.murmur3_128().hashBytes(data);
        Slice actual = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((byte[])actual.getBytes(), (byte[])expected.asBytes());
    }

    @Test(invocationCount=100)
    public void testMoreThan16Bytes() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        HashCode expected = Hashing.murmur3_128().hashBytes(data);
        Slice actual = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((byte[])actual.getBytes(), (byte[])expected.asBytes());
    }

    @Test(invocationCount=100)
    public void testOffsetAndLength() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        int offset = 13;
        int length = 55;
        HashCode expected = Hashing.murmur3_128().hashBytes(data, offset, length);
        Slice actual = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data), (int)offset, (int)length);
        Assert.assertEquals((byte[])actual.getBytes(), (byte[])expected.asBytes());
    }

    @Test(invocationCount=100)
    public void testNonDefaultSeed() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        int seed = 123456789;
        HashCode expected = Hashing.murmur3_128((int)seed).hashBytes(data);
        Slice actual = Murmur3Hash128.hash((long)seed, (Slice)Slices.wrappedBuffer((byte[])data), (int)0, (int)data.length);
        Assert.assertEquals((byte[])actual.getBytes(), (byte[])expected.asBytes());
    }

    @Test
    public void testTail() throws Exception {
        for (int i = 0; i < 16; ++i) {
            byte[] data = TestMurmur3Hash128.randomBytes(50 + i);
            HashCode expected = Hashing.murmur3_128().hashBytes(data);
            Slice actual = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data));
            Assert.assertEquals((byte[])actual.getBytes(), (byte[])expected.asBytes());
        }
    }

    @Test(invocationCount=100)
    public void testLessThan16Bytes64() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(ThreadLocalRandom.current().nextInt(16));
        long expected = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data)).getLong(0);
        long actual = Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((long)actual, (long)expected);
    }

    @Test(invocationCount=100)
    public void testMoreThan16Bytes64() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        long expected = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data)).getLong(0);
        long actual = Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((long)actual, (long)expected);
    }

    @Test(invocationCount=100)
    public void testOffsetAndLength64() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        int offset = 13;
        int length = 55;
        long expected = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data), (int)offset, (int)length).getLong(0);
        long actual = Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])data), (int)offset, (int)length);
        Assert.assertEquals((long)actual, (long)expected);
    }

    @Test(invocationCount=100)
    public void testNonDefaultSeed64() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(131);
        int seed = 123456789;
        long expected = Murmur3Hash128.hash((long)seed, (Slice)Slices.wrappedBuffer((byte[])data), (int)0, (int)data.length).getLong(0);
        long actual = Murmur3Hash128.hash64((long)seed, (Slice)Slices.wrappedBuffer((byte[])data), (int)0, (int)data.length);
        Assert.assertEquals((long)actual, (long)expected);
    }

    @Test
    public void testTail64() throws Exception {
        for (int i = 0; i < 16; ++i) {
            byte[] data = TestMurmur3Hash128.randomBytes(50 + i);
            long expected = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data)).getLong(0);
            long actual = Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])data));
            Assert.assertEquals((long)actual, (long)expected);
        }
    }

    @Test(invocationCount=100)
    public void test64ReturnsMsb() throws Exception {
        byte[] data = TestMurmur3Hash128.randomBytes(ThreadLocalRandom.current().nextInt(200));
        long expected = Murmur3Hash128.hash((Slice)Slices.wrappedBuffer((byte[])data)).getLong(0);
        long actual = Murmur3Hash128.hash64((Slice)Slices.wrappedBuffer((byte[])data));
        Assert.assertEquals((long)actual, (long)expected);
    }

    @Test(invocationCount=100)
    public void testSingleLong() throws Exception {
        long value = ThreadLocalRandom.current().nextLong();
        Slice slice = Slices.allocate((int)8);
        slice.setLong(0, value);
        long expected = Murmur3Hash128.hash64((Slice)slice);
        long actual = Murmur3Hash128.hash64((long)value);
        Assert.assertEquals((long)actual, (long)expected);
    }

    private static byte[] randomBytes(int length) {
        byte[] result = new byte[length];
        ThreadLocalRandom.current().nextBytes(result);
        return result;
    }
}

