/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=5)
@Warmup(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkSlice {
    @Benchmark
    public Object compareTo(BenchmarkData data) throws Throwable {
        return data.slice1.compareTo(0, data.slice1.length(), data.slice2, 0, data.slice2.length());
    }

    @Benchmark
    public Object equalsUnchecked(BenchmarkData data) throws Throwable {
        return data.slice1.equalsUnchecked(0, data.slice2, 0, data.slice1.length());
    }

    @Benchmark
    public Object equalsObject(BenchmarkData data) throws Throwable {
        return data.slice1.equals((Object)data.slice2);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkSlice().equalsObject(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSlice.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "7", "8", "16", "32", "64", "127", "32779"})
        private int size = 1;
        private Slice slice1;
        private Slice slice2;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.slice1 = Slices.allocate((int)this.size);
            this.slice2 = Slices.allocate((int)this.size);
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.slice1.setByte(this.size - 1, 1);
            } else {
                this.slice2.setByte(this.size - 1, 1);
            }
        }
    }
}

