/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceCompactFlag {
    @Test
    public void testSliceConstructors() throws Exception {
        TestSliceCompactFlag.assertCompact(new Slice());
        boolean[] booleanArray = new boolean[]{true, false, false, true, false, true};
        TestSliceCompactFlag.assertCompact(new Slice(booleanArray, 0, booleanArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(booleanArray, 0, booleanArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(booleanArray, 1, booleanArray.length - 1));
        byte[] byteArray = new byte[]{0, 1, 2, 3, 4, 5};
        TestSliceCompactFlag.assertCompact(new Slice(byteArray));
        TestSliceCompactFlag.assertCompact(new Slice(byteArray, 0, byteArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(byteArray, 0, byteArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(byteArray, 1, byteArray.length - 1));
        short[] shortArray = new short[]{0, 1, 2, 3, 4, 5};
        TestSliceCompactFlag.assertCompact(new Slice(shortArray, 0, shortArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(shortArray, 0, shortArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(shortArray, 1, shortArray.length - 1));
        int[] intArray = new int[]{0, 1, 2, 3, 4, 5};
        TestSliceCompactFlag.assertCompact(new Slice(intArray, 0, intArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(intArray, 0, intArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(intArray, 1, intArray.length - 1));
        long[] longArray = new long[]{0L, 1L, 2L, 3L, 4L, 5L};
        TestSliceCompactFlag.assertCompact(new Slice(longArray, 0, longArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(longArray, 0, longArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(longArray, 1, longArray.length - 1));
        float[] floatArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        TestSliceCompactFlag.assertCompact(new Slice(floatArray, 0, floatArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(floatArray, 0, floatArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(floatArray, 1, floatArray.length - 1));
        double[] doubleArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        TestSliceCompactFlag.assertCompact(new Slice(doubleArray, 0, doubleArray.length));
        TestSliceCompactFlag.assertNotCompact(new Slice(doubleArray, 0, doubleArray.length - 1));
        TestSliceCompactFlag.assertNotCompact(new Slice(doubleArray, 1, doubleArray.length - 1));
    }

    @Test
    public void testSubSliceAndCopy() {
        byte[] byteArray = new byte[]{0, 1, 2, 3, 4, 5};
        Slice slice = new Slice(byteArray);
        TestSliceCompactFlag.assertCompact(slice);
        TestSliceCompactFlag.assertCompact(slice.slice(0, slice.length()));
        Assert.assertSame((Object)slice.slice(0, slice.length()), (Object)slice);
        TestSliceCompactFlag.assertCompact(Slices.copyOf((Slice)slice));
        Assert.assertNotSame((Object)Slices.copyOf((Slice)slice).getBase(), (Object)slice.getBase());
        TestSliceCompactFlag.assertCompact(Slices.copyOf((Slice)slice, (int)0, (int)(slice.length() - 1)));
        TestSliceCompactFlag.assertCompact(Slices.copyOf((Slice)slice, (int)1, (int)(slice.length() - 1)));
        Slice subSlice1 = slice.slice(0, slice.length() - 1);
        Slice subSlice2 = slice.slice(1, slice.length() - 1);
        TestSliceCompactFlag.assertNotCompact(subSlice1);
        TestSliceCompactFlag.assertNotCompact(subSlice2);
        TestSliceCompactFlag.assertCompact(Slices.copyOf((Slice)subSlice1));
        TestSliceCompactFlag.assertCompact(Slices.copyOf((Slice)subSlice2));
    }

    @Test
    public void testWrapDirectBuffer() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocateDirect(50);
        for (int i = 0; i < 50; ++i) {
            buffer.put((byte)i);
        }
        buffer.rewind();
        Slice slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertNotCompact(slice);
        buffer.position(10).limit(30);
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertNotCompact(slice);
        buffer = buffer.slice();
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertNotCompact(slice);
    }

    @Test
    public void testWrapHeapBuffer() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(50);
        for (int i = 0; i < 50; ++i) {
            buffer.put((byte)i);
        }
        buffer.rewind();
        Slice slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertCompact(slice);
        buffer.position(10).limit(30);
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertNotCompact(slice);
        buffer = buffer.slice();
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        TestSliceCompactFlag.assertNotCompact(slice);
    }

    private static void assertCompact(Slice data) {
        Assert.assertTrue((boolean)data.isCompact());
    }

    private static void assertNotCompact(Slice data) {
        Assert.assertFalse((boolean)data.isCompact());
    }
}

