/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSlices {
    @Test
    public void testWrapDirectBuffer() throws Exception {
        TestSlices.testWrapping(ByteBuffer.allocateDirect(50));
    }

    @Test
    public void testWrapHeapBuffer() throws Exception {
        TestSlices.testWrapping(ByteBuffer.allocate(50));
    }

    @Test
    public void testWrapHeapBufferRetainedSize() {
        ByteBuffer heapByteBuffer = ByteBuffer.allocate(50);
        Slice slice = Slices.wrappedBuffer((ByteBuffer)heapByteBuffer);
        Assert.assertEquals((long)slice.getRetainedSize(), (long)((long)ClassLayout.parseClass(Slice.class).instanceSize() + SizeOf.sizeOf((byte[])heapByteBuffer.array())));
    }

    private static void testWrapping(ByteBuffer buffer) {
        int i;
        for (int i2 = 0; i2 < 50; ++i2) {
            buffer.put((byte)i2);
        }
        buffer.rewind();
        Slice slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)50);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)i);
        }
        buffer.position(10).limit(30);
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)20);
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)(i + 10));
        }
        buffer = buffer.slice();
        slice = Slices.wrappedBuffer((ByteBuffer)buffer);
        Assert.assertEquals((int)slice.length(), (int)20);
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((int)slice.getByte(i), (int)(i + 10));
        }
    }

    @Test
    public void testWrapAllTypes() {
        boolean[] booleanArray = new boolean[]{true, false, false, true, false, true};
        Assert.assertEquals((Slices.wrappedBooleanArray((boolean[])booleanArray).getByte(0) == 1 ? 1 : 0) != 0, (boolean)booleanArray[0]);
        Assert.assertEquals((Slices.wrappedBooleanArray((boolean[])booleanArray, (int)1, (int)4).getByte(0) == 1 ? 1 : 0) != 0, (boolean)booleanArray[1]);
        Assert.assertEquals((int)Slices.wrappedBooleanArray((boolean[])booleanArray, (int)1, (int)4).length(), (int)4);
        Assert.assertEquals((Slices.wrappedBooleanArray((boolean[])booleanArray).getByte(5) == 1 ? 1 : 0) != 0, (boolean)booleanArray[5]);
        byte[] byteArray = new byte[]{0, 1, 2, 3, 4, 5};
        Assert.assertEquals((byte)Slices.wrappedBuffer((byte[])byteArray).getByte(0), (byte)byteArray[0]);
        Assert.assertEquals((byte)Slices.wrappedBuffer((byte[])byteArray, (int)1, (int)4).getByte(0), (byte)byteArray[1]);
        Assert.assertEquals((int)Slices.wrappedBuffer((byte[])byteArray, (int)1, (int)4).length(), (int)4);
        Assert.assertEquals((byte)Slices.wrappedBuffer((byte[])byteArray).getByte(5), (byte)byteArray[5]);
        short[] shortArray = new short[]{0, 1, 2, 3, 4, 5};
        Assert.assertEquals((short)Slices.wrappedShortArray((short[])shortArray).getShort(0), (short)shortArray[0]);
        Assert.assertEquals((short)Slices.wrappedShortArray((short[])shortArray, (int)1, (int)4).getShort(0), (short)shortArray[1]);
        Assert.assertEquals((int)Slices.wrappedShortArray((short[])shortArray, (int)1, (int)4).length(), (int)8);
        Assert.assertEquals((short)Slices.wrappedShortArray((short[])shortArray).getShort(10), (short)shortArray[5]);
        int[] intArray = new int[]{0, 1, 2, 3, 4, 5};
        Assert.assertEquals((int)Slices.wrappedIntArray((int[])intArray).getInt(0), (int)intArray[0]);
        Assert.assertEquals((int)Slices.wrappedIntArray((int[])intArray, (int)1, (int)4).getInt(0), (int)intArray[1]);
        Assert.assertEquals((int)Slices.wrappedIntArray((int[])intArray, (int)1, (int)4).length(), (int)16);
        Assert.assertEquals((int)Slices.wrappedIntArray((int[])intArray).getInt(20), (int)intArray[5]);
        long[] longArray = new long[]{0L, 1L, 2L, 3L, 4L, 5L};
        Assert.assertEquals((long)Slices.wrappedLongArray((long[])longArray).getLong(0), (long)longArray[0]);
        Assert.assertEquals((long)Slices.wrappedLongArray((long[])longArray, (int)1, (int)4).getLong(0), (long)longArray[1]);
        Assert.assertEquals((int)Slices.wrappedLongArray((long[])longArray, (int)1, (int)4).length(), (int)32);
        Assert.assertEquals((long)Slices.wrappedLongArray((long[])longArray).getLong(40), (long)longArray[5]);
        float[] floatArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Assert.assertEquals((Object)Float.valueOf(Slices.wrappedFloatArray((float[])floatArray).getFloat(0)), (Object)Float.valueOf(floatArray[0]));
        Assert.assertEquals((Object)Float.valueOf(Slices.wrappedFloatArray((float[])floatArray, (int)1, (int)4).getFloat(0)), (Object)Float.valueOf(floatArray[1]));
        Assert.assertEquals((int)Slices.wrappedFloatArray((float[])floatArray, (int)1, (int)4).length(), (int)16);
        Assert.assertEquals((Object)Float.valueOf(Slices.wrappedFloatArray((float[])floatArray).getFloat(20)), (Object)Float.valueOf(floatArray[5]));
        double[] doubleArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((Object)Slices.wrappedDoubleArray((double[])doubleArray).getDouble(0), (Object)doubleArray[0]);
        Assert.assertEquals((Object)Slices.wrappedDoubleArray((double[])doubleArray, (int)1, (int)4).getDouble(0), (Object)doubleArray[1]);
        Assert.assertEquals((int)Slices.wrappedDoubleArray((double[])doubleArray, (int)1, (int)4).length(), (int)32);
        Assert.assertEquals((Object)Slices.wrappedDoubleArray((double[])doubleArray).getDouble(40), (Object)doubleArray[5]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot allocate slice larger than 2147483639 bytes")
    public void testAllocationLimit() {
        Slices.allocate((int)0x7FFFFFFE);
    }
}

