/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

public class DecayCounter {
    static final long RESCALE_THRESHOLD_SECONDS = 50L;
    private final double alpha;
    private final Ticker ticker;
    private long landmarkInSeconds;
    private double count;

    public DecayCounter(double alpha) {
        this(alpha, Ticker.systemTicker());
    }

    public DecayCounter(double alpha, Ticker ticker) {
        this.alpha = alpha;
        this.ticker = ticker;
        this.landmarkInSeconds = this.getTickInSeconds();
    }

    public synchronized void add(long value) {
        long nowInSeconds = this.getTickInSeconds();
        if (nowInSeconds - this.landmarkInSeconds >= 50L) {
            this.rescaleToNewLandmark(nowInSeconds);
        }
        this.count += (double)value * this.weight(nowInSeconds, this.landmarkInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void merge(DecayCounter decayCounter) {
        Preconditions.checkNotNull((Object)decayCounter, (Object)"decayCounter is null");
        Preconditions.checkArgument((decayCounter.alpha == this.alpha ? 1 : 0) != 0, (String)"Expected decayCounter to have alpha %s, but was %s", (Object[])new Object[]{this.alpha, decayCounter.alpha});
        DecayCounter decayCounter2 = decayCounter;
        synchronized (decayCounter2) {
            if (this.landmarkInSeconds < decayCounter.landmarkInSeconds) {
                this.rescaleToNewLandmark(decayCounter.landmarkInSeconds);
                this.count += decayCounter.count;
            } else {
                double otherRescaledCount = decayCounter.count / this.weight(this.landmarkInSeconds, decayCounter.landmarkInSeconds);
                this.count += otherRescaledCount;
            }
        }
    }

    private void rescaleToNewLandmark(long newLandMarkInSeconds) {
        this.count /= this.weight(newLandMarkInSeconds, this.landmarkInSeconds);
        this.landmarkInSeconds = newLandMarkInSeconds;
    }

    @Managed
    public synchronized void reset() {
        this.landmarkInSeconds = this.getTickInSeconds();
        this.count = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void resetTo(DecayCounter counter) {
        DecayCounter decayCounter = counter;
        synchronized (decayCounter) {
            this.landmarkInSeconds = counter.landmarkInSeconds;
            this.count = counter.count;
        }
    }

    @Managed
    public synchronized double getCount() {
        long nowInSeconds = this.getTickInSeconds();
        return this.count / this.weight(nowInSeconds, this.landmarkInSeconds);
    }

    @Managed
    public synchronized double getRate() {
        return this.getCount() * this.alpha;
    }

    private double weight(long timestampInSeconds, long landmarkInSeconds) {
        return Math.exp(this.alpha * (double)(timestampInSeconds - landmarkInSeconds));
    }

    private long getTickInSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.ticker.read());
    }

    public DecayCounterSnapshot snapshot() {
        return new DecayCounterSnapshot(this.getCount(), this.getRate());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.getCount()).add("rate", this.getRate()).toString();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public static class DecayCounterSnapshot {
        private final double count;
        private final double rate;

        @JsonCreator
        public DecayCounterSnapshot(@JsonProperty(value="count") double count, @JsonProperty(value="rate") double rate) {
            this.count = count;
            this.rate = rate;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getRate() {
            return this.rate;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("rate", this.rate).toString();
        }
    }
}

