/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.weakref.jmx.Managed;

public class PauseMeter {
    private static final Logger LOG = Logger.get(PauseMeter.class);
    private final long sleepNanos;
    @GuardedBy(value="histogram")
    private final Histogram histogram = new Histogram(3);
    @GuardedBy(value="histogram")
    private long totalPauseNanos;
    private final Supplier<Histogram> snapshot = Suppliers.memoizeWithExpiration(this::makeSnapshot, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    private final Thread thread;
    public volatile Long allocatedObject;

    public PauseMeter() {
        this(new Duration(10.0, TimeUnit.MILLISECONDS));
    }

    public PauseMeter(Duration sleepTime) {
        this.sleepNanos = sleepTime.roundTo(TimeUnit.NANOSECONDS);
        this.thread = new Thread(this::run, "VM Pause Meter");
        this.thread.setDaemon(true);
    }

    @PostConstruct
    public void start() {
        this.thread.start();
    }

    @PreDestroy
    public void stop() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Histogram makeSnapshot() {
        Histogram histogram = this.histogram;
        synchronized (histogram) {
            return this.histogram.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        long shortestObservableInterval = Long.MAX_VALUE;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                long before = System.nanoTime();
                TimeUnit.NANOSECONDS.sleep(this.sleepNanos);
                this.allocatedObject = new Long(before);
                long after = System.nanoTime();
                long delta = after - before;
                shortestObservableInterval = Math.min(shortestObservableInterval, delta);
                long pauseNanos = delta - shortestObservableInterval;
                Histogram histogram = this.histogram;
                synchronized (histogram) {
                    this.histogram.recordValue(pauseNanos);
                    this.totalPauseNanos += pauseNanos;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                LOG.warn(e, "Unexpected error");
            }
        }
    }

    @Managed(description="< 10ms")
    public long getLessThan10msPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(0L, TimeUnit.MILLISECONDS.toNanos(10L));
    }

    @Managed(description="10ms to 50ms")
    public long get10msTo50msPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(50L));
    }

    @Managed(description="50ms to 500ms")
    public long get50msTo500msPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.MILLISECONDS.toNanos(50L), TimeUnit.MILLISECONDS.toNanos(500L));
    }

    @Managed(description="500ms to 1s")
    public long get500msTo1sPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.MILLISECONDS.toNanos(500L), TimeUnit.SECONDS.toNanos(1L));
    }

    @Managed(description="1s to 10s")
    public long get1sTo10sPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.SECONDS.toNanos(1L), TimeUnit.SECONDS.toNanos(10L));
    }

    @Managed(description="10s to 1m")
    public long get10sTo1mPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.SECONDS.toNanos(10L), TimeUnit.MINUTES.toNanos(1L));
    }

    @Managed(description="> 1m")
    public long getGreaterThan1mPauses() {
        return ((Histogram)this.snapshot.get()).getCountBetweenValues(TimeUnit.MINUTES.toNanos(1L), Long.MAX_VALUE);
    }

    @Managed(description="Per-bucket counts")
    public Map<Double, Long> getCounts() {
        TreeMap<Double, Long> result = new TreeMap<Double, Long>();
        for (HistogramIterationValue entry : ((Histogram)this.snapshot.get()).logarithmicBucketValues(TimeUnit.MILLISECONDS.toNanos(1L), 2.0)) {
            double median = (double)(entry.getValueIteratedTo() + entry.getValueIteratedFrom()) / 2.0;
            result.put(PauseMeter.round(median / (double)TimeUnit.MILLISECONDS.toNanos(1L), 2), entry.getCountAddedInThisIterationStep());
        }
        return result;
    }

    @Managed(description="Per-bucket total pause time in s")
    public Map<Double, Double> getSums() {
        long previous = 0L;
        TreeMap<Double, Double> result = new TreeMap<Double, Double>();
        for (HistogramIterationValue entry : ((Histogram)this.snapshot.get()).logarithmicBucketValues(TimeUnit.MILLISECONDS.toNanos(1L), 2.0)) {
            double median = (double)(entry.getValueIteratedTo() + entry.getValueIteratedFrom()) / 2.0;
            long current = entry.getTotalValueToThisValue();
            result.put(PauseMeter.round(median / (double)TimeUnit.MILLISECONDS.toNanos(1L), 2), PauseMeter.round((double)(current - previous) * 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), 2));
            previous = current;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public double getTotalPauseSeconds() {
        Histogram histogram = this.histogram;
        synchronized (histogram) {
            return (double)this.totalPauseNanos * 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
        }
    }

    private static double round(double value, int digits) {
        double scale = Math.pow(10.0, digits);
        return (double)Math.round(value * scale) / scale;
    }
}

