/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import io.airlift.units.Duration;
import jakarta.annotation.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CpuTimer {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final Duration ZERO_NANOS = new Duration(0.0, TimeUnit.NANOSECONDS);
    private final Ticker ticker;
    private final long wallStartTime;
    private final long cpuStartTime;
    private final long userStartTime;
    private long intervalWallStart;
    private long intervalCpuStart;
    private long intervalUserStart;

    public CpuTimer() {
        this(Ticker.systemTicker(), true);
    }

    public CpuTimer(boolean collectUserTime) {
        this(Ticker.systemTicker(), collectUserTime);
    }

    public CpuTimer(Ticker ticker, boolean collectUserTime) {
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.wallStartTime = ticker.read();
        this.cpuStartTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        this.userStartTime = collectUserTime ? THREAD_MX_BEAN.getCurrentThreadUserTime() : -1L;
        this.intervalWallStart = this.wallStartTime;
        this.intervalCpuStart = this.cpuStartTime;
        this.intervalUserStart = this.userStartTime;
    }

    public long getWallStartTimeNanos() {
        return this.wallStartTime;
    }

    public long getIntervalWallStartNanos() {
        return this.intervalWallStart;
    }

    public CpuDuration startNewInterval() {
        long currentWallTime = this.ticker.read();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = this.intervalUserStart == -1L ? -1L : THREAD_MX_BEAN.getCurrentThreadUserTime();
        CpuDuration cpuDuration = new CpuDuration(CpuTimer.nanosBetween(this.intervalWallStart, currentWallTime), CpuTimer.nanosBetween(this.intervalCpuStart, currentCpuTime), currentUserTime == -1L ? null : CpuTimer.nanosBetween(this.intervalUserStart, currentUserTime));
        this.intervalWallStart = currentWallTime;
        this.intervalCpuStart = currentCpuTime;
        this.intervalUserStart = currentUserTime;
        return cpuDuration;
    }

    public CpuDuration elapsedIntervalTime() {
        long currentWallTime = this.ticker.read();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = this.intervalUserStart == -1L ? -1L : THREAD_MX_BEAN.getCurrentThreadUserTime();
        return new CpuDuration(CpuTimer.nanosBetween(this.intervalWallStart, currentWallTime), CpuTimer.nanosBetween(this.intervalCpuStart, currentCpuTime), currentUserTime == -1L ? null : CpuTimer.nanosBetween(this.intervalUserStart, currentUserTime));
    }

    public CpuDuration elapsedTime() {
        long currentWallTime = this.ticker.read();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = this.userStartTime == -1L ? -1L : THREAD_MX_BEAN.getCurrentThreadUserTime();
        return new CpuDuration(CpuTimer.nanosBetween(this.wallStartTime, currentWallTime), CpuTimer.nanosBetween(this.cpuStartTime, currentCpuTime), currentUserTime == -1L ? null : CpuTimer.nanosBetween(this.userStartTime, currentUserTime));
    }

    private static Duration nanosBetween(long start, long end) {
        return new Duration((double)Math.abs(end - start), TimeUnit.NANOSECONDS);
    }

    public static class CpuDuration {
        private final Duration wall;
        private final Duration cpu;
        @Nullable
        private final Duration user;

        public CpuDuration() {
            this(ZERO_NANOS, ZERO_NANOS, ZERO_NANOS);
        }

        public CpuDuration(Duration wall, Duration cpu, @Nullable Duration user) {
            this.wall = wall;
            this.cpu = cpu;
            this.user = user;
        }

        public Duration getWall() {
            return this.wall;
        }

        public Duration getCpu() {
            return this.cpu;
        }

        public boolean hasUser() {
            return this.user != null;
        }

        public Duration getUser() {
            return this.user == null ? ZERO_NANOS : this.user;
        }

        public Optional<Duration> getUserIfPresent() {
            return Optional.ofNullable(this.user);
        }

        public CpuDuration add(CpuDuration cpuDuration) {
            return new CpuDuration(CpuDuration.addDurations(this.wall, cpuDuration.wall), CpuDuration.addDurations(this.cpu, cpuDuration.cpu), this.user == null || cpuDuration.user == null ? null : CpuDuration.addDurations(this.user, cpuDuration.user));
        }

        public CpuDuration subtract(CpuDuration cpuDuration) {
            return new CpuDuration(CpuDuration.subtractDurations(this.wall, cpuDuration.wall), CpuDuration.subtractDurations(this.cpu, cpuDuration.cpu), this.user == null || cpuDuration.user == null ? null : CpuDuration.subtractDurations(this.user, cpuDuration.user));
        }

        private static Duration addDurations(Duration a, Duration b) {
            return new Duration(a.getValue(TimeUnit.NANOSECONDS) + b.getValue(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        }

        private static Duration subtractDurations(Duration a, Duration b) {
            return new Duration(Math.max(0.0, a.getValue(TimeUnit.NANOSECONDS) - b.getValue(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("wall", (Object)this.wall).add("cpu", (Object)this.cpu).add("user", (Object)this.user).toString();
        }
    }
}

