/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.ExponentialDecay;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

@ThreadSafe
public final class DecayCounter {
    static final long RESCALE_THRESHOLD_SECONDS = 50L;
    private final double alpha;
    private final Ticker ticker;
    private long landmarkInSeconds;
    private double count;

    public DecayCounter(double alpha) {
        this(alpha, Ticker.systemTicker());
    }

    public DecayCounter(double alpha, Ticker ticker) {
        this(0.0, alpha, ticker, TimeUnit.NANOSECONDS.toSeconds(ticker.read()));
    }

    private DecayCounter(double count, double alpha, Ticker ticker, long landmarkInSeconds) {
        this.count = count;
        this.alpha = alpha;
        this.ticker = ticker;
        this.landmarkInSeconds = landmarkInSeconds;
    }

    public DecayCounter duplicate() {
        return new DecayCounter(this.count, this.alpha, this.ticker, this.landmarkInSeconds);
    }

    public synchronized void add(long value) {
        long nowInSeconds = this.getTickInSeconds();
        if (nowInSeconds - this.landmarkInSeconds >= 50L) {
            this.rescaleToNewLandmark(nowInSeconds);
        }
        this.count += (double)value * ExponentialDecay.weight(this.alpha, nowInSeconds, this.landmarkInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void merge(DecayCounter decayCounter) {
        Objects.requireNonNull(decayCounter, "decayCounter is null");
        Preconditions.checkArgument((decayCounter.alpha == this.alpha ? 1 : 0) != 0, (String)"Expected decayCounter to have alpha %s, but was %s", (Object)this.alpha, (Object)decayCounter.alpha);
        DecayCounter decayCounter2 = decayCounter;
        synchronized (decayCounter2) {
            if (this.landmarkInSeconds < decayCounter.landmarkInSeconds) {
                this.rescaleToNewLandmark(decayCounter.landmarkInSeconds);
                this.count += decayCounter.count;
            } else {
                double otherRescaledCount = decayCounter.count / ExponentialDecay.weight(this.alpha, this.landmarkInSeconds, decayCounter.landmarkInSeconds);
                this.count += otherRescaledCount;
            }
        }
    }

    private void rescaleToNewLandmark(long newLandMarkInSeconds) {
        this.count /= ExponentialDecay.weight(this.alpha, newLandMarkInSeconds, this.landmarkInSeconds);
        this.landmarkInSeconds = newLandMarkInSeconds;
    }

    @Managed
    public synchronized void reset() {
        this.landmarkInSeconds = this.getTickInSeconds();
        this.count = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void resetTo(DecayCounter counter) {
        DecayCounter decayCounter = counter;
        synchronized (decayCounter) {
            this.landmarkInSeconds = counter.landmarkInSeconds;
            this.count = counter.count;
        }
    }

    @Managed
    public synchronized double getCount() {
        long nowInSeconds = this.getTickInSeconds();
        return this.count / ExponentialDecay.weight(this.alpha, nowInSeconds, this.landmarkInSeconds);
    }

    @Managed
    public synchronized double getRate() {
        return this.getCount() * this.alpha;
    }

    private long getTickInSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.ticker.read());
    }

    public DecayCounterSnapshot snapshot() {
        double count = this.getCount();
        return new DecayCounterSnapshot(count, count * this.alpha);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.getCount()).add("rate", this.getRate()).toString();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public record DecayCounterSnapshot(double count, double rate) {
    }
}

