/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Verify;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.DecayTDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.Managed;

@ThreadSafe
public class Distribution {
    private static final double[] SNAPSHOT_QUANTILES = new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99};
    private static final double[] PERCENTILES = new double[100];
    private final double alpha;
    @GuardedBy(value="this")
    private DecayTDigest digest;
    private final DecayCounter total;

    public Distribution() {
        this(0.0);
    }

    public Distribution(double alpha) {
        this(alpha, new DecayTDigest(100.0, alpha), new DecayCounter(alpha));
    }

    private Distribution(double alpha, DecayTDigest digest, DecayCounter total) {
        this.alpha = alpha;
        this.digest = Objects.requireNonNull(digest, "digest is null");
        this.total = Objects.requireNonNull(total, "total is null");
    }

    public synchronized void add(long value) {
        this.digest.add(value);
        this.total.add(value);
    }

    public synchronized void add(long value, long count) {
        this.digest.add(value, count);
        this.total.add(value * count);
    }

    public synchronized Distribution duplicate() {
        return new Distribution(this.alpha, this.digest.duplicate(), this.total.duplicate());
    }

    @Managed
    public synchronized void reset() {
        this.total.reset();
        this.digest = new DecayTDigest(100.0, this.alpha);
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getTotal() {
        return this.total.getCount();
    }

    @Managed
    public synchronized double getP01() {
        return this.digest.valueAt(0.01);
    }

    @Managed
    public synchronized double getP05() {
        return this.digest.valueAt(0.05);
    }

    @Managed
    public synchronized double getP10() {
        return this.digest.valueAt(0.1);
    }

    @Managed
    public synchronized double getP25() {
        return this.digest.valueAt(0.25);
    }

    @Managed
    public synchronized double getP50() {
        return this.digest.valueAt(0.5);
    }

    @Managed
    public synchronized double getP75() {
        return this.digest.valueAt(0.75);
    }

    @Managed
    public synchronized double getP90() {
        return this.digest.valueAt(0.9);
    }

    @Managed
    public synchronized double getP95() {
        return this.digest.valueAt(0.95);
    }

    @Managed
    public synchronized double getP99() {
        return this.digest.valueAt(0.99);
    }

    @Managed
    public synchronized double getMin() {
        return this.digest.getMin();
    }

    @Managed
    public synchronized double getMax() {
        return this.digest.getMax();
    }

    @Managed
    public synchronized double getAvg() {
        return this.getTotal() / this.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Double> getPercentiles() {
        double[] values;
        Distribution distribution = this;
        synchronized (distribution) {
            values = this.digest.valuesAt(PERCENTILES);
        }
        Verify.verify((values.length == PERCENTILES.length ? 1 : 0) != 0, (String)"result length mismatch", (Object[])new Object[0]);
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.put(PERCENTILES[i], values[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributionSnapshot snapshot() {
        double[] quantiles;
        double max;
        double min;
        double digestCount;
        double totalCount;
        Distribution distribution = this;
        synchronized (distribution) {
            totalCount = this.total.getCount();
            digestCount = this.digest.getCount();
            min = this.digest.getMin();
            max = this.digest.getMax();
            quantiles = this.digest.valuesAt(SNAPSHOT_QUANTILES);
        }
        double average = totalCount / digestCount;
        return new DistributionSnapshot(digestCount, totalCount, quantiles[0], quantiles[1], quantiles[2], quantiles[3], quantiles[4], quantiles[5], quantiles[6], quantiles[7], quantiles[8], min, max, average);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            Distribution.PERCENTILES[i] = (double)i / 100.0;
        }
    }

    public record DistributionSnapshot(double count, double total, double p01, double p05, double p10, double p25, double p50, double p75, double p90, double p95, double p99, double min, double max, double avg) {
    }
}

