/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Ticker;
import io.airlift.stats.ExponentialDecay;
import io.airlift.stats.TimeDistribution;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TimeStat {
    private final TimeDistribution oneMinute;
    private final TimeDistribution fiveMinutes;
    private final TimeDistribution fifteenMinutes;
    private final TimeDistribution allTime;
    private final Ticker ticker;

    public TimeStat() {
        this(Ticker.systemTicker(), TimeUnit.SECONDS);
    }

    public TimeStat(Ticker ticker) {
        this(ticker, TimeUnit.SECONDS);
    }

    public TimeStat(TimeUnit unit) {
        this(Ticker.systemTicker(), unit);
    }

    public TimeStat(Ticker ticker, TimeUnit unit) {
        this.ticker = ticker;
        this.oneMinute = new TimeDistribution(ticker, ExponentialDecay.oneMinute(), unit);
        this.fiveMinutes = new TimeDistribution(ticker, ExponentialDecay.fiveMinutes(), unit);
        this.fifteenMinutes = new TimeDistribution(ticker, ExponentialDecay.fifteenMinutes(), unit);
        this.allTime = new TimeDistribution(ticker, ExponentialDecay.all(), unit);
    }

    public void add(double value, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("value is not finite: " + value);
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("value is negative: " + value);
        }
        this.addNanos((long)Math.floor(value * (double)timeUnit.toNanos(1L) + 0.5));
    }

    public void add(Duration duration) {
        this.addNanos((long)duration.getValue(TimeUnit.NANOSECONDS));
    }

    public void addNanos(long nanos) {
        if (nanos < 0L) {
            throw new IllegalArgumentException("value is negative: " + nanos);
        }
        this.oneMinute.add(nanos);
        this.fiveMinutes.add(nanos);
        this.fifteenMinutes.add(nanos);
        this.allTime.add(nanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> callable) throws Exception {
        long start = this.ticker.read();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.addNanos(this.ticker.read() - start);
        }
    }

    public BlockTimer time() {
        return new BlockTimer();
    }

    @Managed
    @Nested
    public TimeDistribution getOneMinute() {
        return this.oneMinute;
    }

    @Managed
    @Nested
    public TimeDistribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Managed
    @Nested
    public TimeDistribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Managed
    @Nested
    public TimeDistribution getAllTime() {
        return this.allTime;
    }

    public TimeDistributionStatSnapshot snapshot() {
        return new TimeDistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    @Managed
    public void reset() {
        this.oneMinute.reset();
        this.fiveMinutes.reset();
        this.fifteenMinutes.reset();
        this.allTime.reset();
    }

    public class BlockTimer
    implements AutoCloseable {
        private final long start;

        public BlockTimer() {
            this.start = TimeStat.this.ticker.read();
        }

        @Override
        public void close() {
            TimeStat.this.addNanos(TimeStat.this.ticker.read() - this.start);
        }
    }

    public record TimeDistributionStatSnapshot(TimeDistribution.TimeDistributionSnapshot oneMinute, TimeDistribution.TimeDistributionSnapshot fiveMinute, TimeDistribution.TimeDistributionSnapshot fifteenMinute, TimeDistribution.TimeDistributionSnapshot allTime) {
        public TimeDistributionStatSnapshot {
            Objects.requireNonNull(oneMinute, "oneMinute is null");
            Objects.requireNonNull(fiveMinute, "fiveMinute is null");
            Objects.requireNonNull(fifteenMinute, "fifteenMinute is null");
            Objects.requireNonNull(allTime, "allTime is null");
        }
    }
}

