/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.DecayTDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

public class TimeDistribution {
    @VisibleForTesting
    static final long MERGE_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final double[] SNAPSHOT_QUANTILES = new double[]{0.5, 0.75, 0.9, 0.95, 0.99};
    private static final double[] PERCENTILES = new double[100];
    private static final int STRIPES = 16;
    private final Ticker ticker;
    private final double alpha;
    private final Object[] locks = new Object[16];
    @GuardedBy(value="locks")
    private final DecayTDigest[] partials = new DecayTDigest[16];
    @GuardedBy(value="this")
    private DecayTDigest merged;
    @GuardedBy(value="this")
    private long lastMerge;
    private final DecayCounter total;
    private final DecayCounter partialTotal;
    private final TimeUnit unit;

    public TimeDistribution() {
        this(TimeUnit.SECONDS);
    }

    public TimeDistribution(TimeUnit unit) {
        this(Ticker.systemTicker(), 0.0, unit);
    }

    public TimeDistribution(Ticker ticker) {
        this(ticker, 0.0, TimeUnit.SECONDS);
    }

    public TimeDistribution(double alpha) {
        this(Ticker.systemTicker(), alpha, TimeUnit.SECONDS);
    }

    public TimeDistribution(Ticker ticker, double alpha, TimeUnit unit) {
        Objects.requireNonNull(ticker, "ticker is null");
        Objects.requireNonNull(unit, "unit is null");
        this.alpha = alpha;
        this.merged = new DecayTDigest(100.0, alpha);
        for (int i = 0; i < 16; ++i) {
            this.locks[i] = new Object();
            this.partials[i] = new DecayTDigest(100.0, alpha);
        }
        this.total = new DecayCounter(alpha);
        this.partialTotal = new DecayCounter(alpha);
        this.ticker = ticker;
        this.unit = unit;
        this.lastMerge = ticker.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long value) {
        int segment = Math.floorMod(Thread.currentThread().threadId(), 16);
        Object object = this.locks[segment];
        synchronized (object) {
            this.partials[segment].add(value);
        }
        this.partialTotal.add(value);
    }

    @Managed
    public double getCount() {
        return this.mergeAndGetIfNeeded().getCount();
    }

    @Managed
    public double getP50() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().valueAt(0.5));
    }

    @Managed
    public double getP75() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().valueAt(0.75));
    }

    @Managed
    public double getP90() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().valueAt(0.9));
    }

    @Managed
    public double getP95() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().valueAt(0.95));
    }

    @Managed
    public double getP99() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().valueAt(0.99));
    }

    @Managed
    public double getMin() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().getMin());
    }

    @Managed
    public double getMax() {
        return this.convertToUnit(this.mergeAndGetIfNeeded().getMax());
    }

    @Managed
    public synchronized double getAvg() {
        double digestCount = this.mergeAndGetIfNeeded().getCount();
        return this.convertToUnit(this.total.getCount()) / digestCount;
    }

    @Managed
    public TimeUnit getUnit() {
        return this.unit;
    }

    @Managed
    public Map<Double, Double> getPercentiles() {
        double[] values = this.mergeAndGetIfNeeded(true).valuesAt(PERCENTILES);
        Verify.verify((values.length == PERCENTILES.length ? 1 : 0) != 0, (String)"values length mismatch", (Object[])new Object[0]);
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.put(PERCENTILES[i], values[i]);
        }
        return result;
    }

    private DecayTDigest mergeAndGetIfNeeded() {
        return this.mergeAndGetIfNeeded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecayTDigest mergeAndGetIfNeeded(boolean forceMerge) {
        TimeDistribution timeDistribution = this;
        synchronized (timeDistribution) {
            if (forceMerge || this.ticker.read() - this.lastMerge >= MERGE_THRESHOLD_NANOS) {
                for (int i = 0; i < 16; ++i) {
                    Object object = this.locks[i];
                    synchronized (object) {
                        this.merged.merge(this.partials[i]);
                        this.partials[i] = new DecayTDigest(100.0, this.alpha);
                        continue;
                    }
                }
                this.total.merge(this.partialTotal);
                this.partialTotal.reset();
                this.lastMerge = this.ticker.read();
            }
        }
        return this.merged;
    }

    private double convertToUnit(double nanos) {
        return TimeDistribution.convertToUnit(nanos, this.unit.toNanos(1L));
    }

    private static double convertToUnit(double nanos, double unitNanos) {
        return nanos / unitNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeDistributionSnapshot snapshot() {
        double[] quantiles;
        double max;
        double min;
        double digestCount;
        double totalCount;
        TimeDistribution timeDistribution = this;
        synchronized (timeDistribution) {
            DecayTDigest digest = this.mergeAndGetIfNeeded(true);
            totalCount = this.total.getCount();
            digestCount = digest.getCount();
            min = digest.getMin();
            max = digest.getMax();
            quantiles = digest.valuesAt(SNAPSHOT_QUANTILES);
        }
        double unitNanos = this.unit.toNanos(1L);
        double average = TimeDistribution.convertToUnit(totalCount, unitNanos) / digestCount;
        return new TimeDistributionSnapshot(digestCount, TimeDistribution.convertToUnit(quantiles[0], unitNanos), TimeDistribution.convertToUnit(quantiles[1], unitNanos), TimeDistribution.convertToUnit(quantiles[2], unitNanos), TimeDistribution.convertToUnit(quantiles[3], unitNanos), TimeDistribution.convertToUnit(quantiles[4], unitNanos), TimeDistribution.convertToUnit(min, unitNanos), TimeDistribution.convertToUnit(max, unitNanos), average, this.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public synchronized void reset() {
        this.total.reset();
        this.partialTotal.reset();
        this.merged = new DecayTDigest(100.0, this.alpha);
        for (int i = 0; i < this.partials.length; ++i) {
            Object object = this.locks[i];
            synchronized (object) {
                this.partials[i] = new DecayTDigest(100.0, this.alpha);
                continue;
            }
        }
    }

    static {
        for (int i = 0; i < 100; ++i) {
            TimeDistribution.PERCENTILES[i] = (double)i / 100.0;
        }
    }

    public record TimeDistributionSnapshot(double count, double p50, double p75, double p90, double p95, double p99, double min, double max, double avg, TimeUnit unit) {
        public TimeDistributionSnapshot {
            Objects.requireNonNull(unit, "unit is null");
        }
    }
}

