/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.ExponentialDecay;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public final class CounterStat {
    private final LongAdder count = new LongAdder();
    private final DecayCounter oneMinute = new DecayCounter(ExponentialDecay.oneMinute());
    private final DecayCounter fiveMinute = new DecayCounter(ExponentialDecay.fiveMinutes());
    private final DecayCounter fifteenMinute = new DecayCounter(ExponentialDecay.fifteenMinutes());

    public void update(long count) {
        this.oneMinute.add(count);
        this.fiveMinute.add(count);
        this.fifteenMinute.add(count);
        this.count.add(count);
    }

    public void merge(CounterStat counterStat) {
        Objects.requireNonNull(counterStat, "counterStat is null");
        this.oneMinute.merge(counterStat.getOneMinute());
        this.fiveMinute.merge(counterStat.getFiveMinute());
        this.fifteenMinute.merge(counterStat.getFifteenMinute());
        this.count.add(counterStat.getTotalCount());
    }

    @Managed
    public void reset() {
        this.oneMinute.reset();
        this.fiveMinute.reset();
        this.fifteenMinute.reset();
        this.count.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void resetTo(CounterStat counterStat) {
        this.oneMinute.resetTo(counterStat.getOneMinute());
        this.fiveMinute.resetTo(counterStat.getFiveMinute());
        this.fifteenMinute.resetTo(counterStat.getFifteenMinute());
        LongAdder longAdder = this.count;
        synchronized (longAdder) {
            this.count.reset();
            this.count.add(counterStat.getTotalCount());
        }
    }

    @Managed
    public long getTotalCount() {
        return this.count.sum();
    }

    @Managed
    @Nested
    public DecayCounter getOneMinute() {
        return this.oneMinute;
    }

    @Managed
    @Nested
    public DecayCounter getFiveMinute() {
        return this.fiveMinute;
    }

    @Managed
    @Nested
    public DecayCounter getFifteenMinute() {
        return this.fifteenMinute;
    }

    public CounterStatSnapshot snapshot() {
        return new CounterStatSnapshot(this.getTotalCount(), this.getOneMinute().snapshot(), this.getFiveMinute().snapshot(), this.getFifteenMinute().snapshot());
    }

    public static class CounterStatSnapshot {
        private final long totalCount;
        private final DecayCounter.DecayCounterSnapshot oneMinute;
        private final DecayCounter.DecayCounterSnapshot fiveMinute;
        private final DecayCounter.DecayCounterSnapshot fifteenMinute;

        @JsonCreator
        public CounterStatSnapshot(@JsonProperty(value="totalCount") long totalCount, @JsonProperty(value="oneMinute") DecayCounter.DecayCounterSnapshot oneMinute, @JsonProperty(value="fiveMinute") DecayCounter.DecayCounterSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") DecayCounter.DecayCounterSnapshot fifteenMinute) {
            this.totalCount = totalCount;
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
        }

        @JsonProperty
        public long getTotalCount() {
            return this.totalCount;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getFiveMinute() {
            return this.fiveMinute;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getFifteenMinute() {
            return this.fifteenMinute;
        }
    }
}

