/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import io.airlift.stats.Distribution;
import io.airlift.stats.ExponentialDecay;
import java.util.Objects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DistributionStat {
    private final Distribution oneMinute = new Distribution(ExponentialDecay.oneMinute());
    private final Distribution fiveMinutes = new Distribution(ExponentialDecay.fiveMinutes());
    private final Distribution fifteenMinutes = new Distribution(ExponentialDecay.fifteenMinutes());
    private final Distribution allTime = new Distribution();

    public void add(long value) {
        this.oneMinute.add(value);
        this.fiveMinutes.add(value);
        this.fifteenMinutes.add(value);
        this.allTime.add(value);
    }

    public void add(long value, long count) {
        this.oneMinute.add(value, count);
        this.fiveMinutes.add(value, count);
        this.fifteenMinutes.add(value, count);
        this.allTime.add(value, count);
    }

    @Managed
    @Nested
    public Distribution getOneMinute() {
        return this.oneMinute;
    }

    @Managed
    @Nested
    public Distribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Managed
    @Nested
    public Distribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Managed
    @Nested
    public Distribution getAllTime() {
        return this.allTime;
    }

    public DistributionStatSnapshot snapshot() {
        return new DistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    public record DistributionStatSnapshot(Distribution.DistributionSnapshot oneMinute, Distribution.DistributionSnapshot fiveMinute, Distribution.DistributionSnapshot fifteenMinute, Distribution.DistributionSnapshot allTime) {
        public DistributionStatSnapshot {
            Objects.requireNonNull(oneMinute, "oneMinute is null");
            Objects.requireNonNull(fiveMinute, "fiveMinute is null");
            Objects.requireNonNull(fifteenMinute, "fifteenMinute is null");
            Objects.requireNonNull(allTime, "allTime is null");
        }
    }
}

