/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.testing.mysql.EmbeddedMySql;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;

public final class TestingMySqlServer
implements Closeable {
    private static final Logger log = Logger.get(TestingMySqlServer.class);
    private final String user;
    private final String password;
    private final Set<String> databases;
    private final int port;
    private final String version;
    private final EmbeddedMySql server;

    public TestingMySqlServer(String user, String password, String ... databases) throws Exception {
        this(user, password, (Iterable<String>)ImmutableList.copyOf((Object[])databases));
    }

    public TestingMySqlServer(String user, String password, Iterable<String> databases) throws Exception {
        this.user = Objects.requireNonNull(user, "user is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.databases = ImmutableSet.copyOf(Objects.requireNonNull(databases, "databases is null"));
        this.server = new EmbeddedMySql();
        this.port = this.server.getPort();
        try (Connection connection = this.server.getMySqlDatabase();){
            this.version = connection.getMetaData().getDatabaseProductVersion();
            try (Statement statement = connection.createStatement();){
                TestingMySqlServer.execute(statement, String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s'", user, password));
                TestingMySqlServer.execute(statement, String.format("GRANT ALL ON *.* to '%s'@'%%' WITH GRANT OPTION", user));
                for (String database : databases) {
                    TestingMySqlServer.execute(statement, String.format("CREATE DATABASE %s", database));
                }
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        log.info("MySQL server ready: %s", new Object[]{this.getJdbcUrl()});
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: %s", new Object[]{sql});
        statement.execute(sql);
    }

    @Override
    public void close() {
        this.server.close();
    }

    public String getMySqlVersion() {
        return this.version;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getDatabases() {
        return this.databases;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.getJdbcUrl("");
    }

    public String getJdbcUrl(String database) {
        return String.format("jdbc:mysql://localhost:%s/%s?user=%s&password=%s&useSSL=false&allowPublicKeyRetrieval=true", this.port, database, this.user, this.password);
    }
}

