/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MySqlOptions {
    private final Duration startupWait;
    private final Duration shutdownWait;
    private final Duration commandTimeout;

    private MySqlOptions(Duration startupWait, Duration shutdownWait, Duration commandTimeout) {
        this.startupWait = Objects.requireNonNull(startupWait, "startupWait is null");
        this.shutdownWait = Objects.requireNonNull(shutdownWait, "shutdownWait is null");
        this.commandTimeout = Objects.requireNonNull(commandTimeout, "commandTimeout is null");
    }

    public Duration getStartupWait() {
        return this.startupWait;
    }

    public Duration getShutdownWait() {
        return this.shutdownWait;
    }

    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration startupWait = new Duration(10.0, TimeUnit.SECONDS);
        private Duration shutdownWait = new Duration(10.0, TimeUnit.SECONDS);
        private Duration commandTimeout = new Duration(30.0, TimeUnit.SECONDS);

        public Builder setStartupWait(Duration startupWait) {
            this.startupWait = Objects.requireNonNull(startupWait, "startupWait is null");
            return this;
        }

        public Builder setShutdownWait(Duration shutdownWait) {
            this.shutdownWait = Objects.requireNonNull(shutdownWait, "shutdownWait is null");
            return this;
        }

        public Builder setCommandTimeout(Duration commandTimeout) {
            this.commandTimeout = Objects.requireNonNull(commandTimeout, "commandTimeout is null");
            return this;
        }

        public MySqlOptions build() {
            return new MySqlOptions(this.startupWait, this.shutdownWait, this.commandTimeout);
        }
    }
}

