/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.postgresql;

import io.airlift.log.Logger;
import io.airlift.testing.postgresql.EmbeddedPostgreSql;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

public final class TestingPostgreSqlServer
implements Closeable {
    private static final Logger log = Logger.get(TestingPostgreSqlServer.class);
    private final String user;
    private final String database;
    private final int port;
    private final EmbeddedPostgreSql server;

    public TestingPostgreSqlServer(String user, String database) throws Exception {
        this.user = Objects.requireNonNull(user, "user is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.server = new EmbeddedPostgreSql();
        this.port = this.server.getPort();
        try (Connection connection = this.server.getPostgresDatabase();
             Statement statement = connection.createStatement();){
            TestingPostgreSqlServer.execute(statement, String.format("CREATE ROLE %s WITH LOGIN SUPERUSER", user));
            TestingPostgreSqlServer.execute(statement, String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", database, user));
        }
        catch (Exception e) {
            this.server.close();
            throw e;
        }
        log.info("PostgreSQL server ready: %s", new Object[]{this.getJdbcUrl()});
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: %s", new Object[]{sql});
        statement.execute(sql);
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.server.getJdbcUrl(this.user, this.database);
    }
}

