/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public final class ValidationAssertions {
    @GuardedBy(value="VALIDATOR")
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    private ValidationAssertions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<ConstraintViolation<T>> validate(T object) {
        Validator validator = VALIDATOR;
        synchronized (validator) {
            return VALIDATOR.validate(object, new Class[0]);
        }
    }

    public static void assertValidates(Object object) {
        ValidationAssertions.assertValidates(object, null);
    }

    public static void assertValidates(Object object, String message) {
        if (!ValidationAssertions.validate(object).isEmpty()) {
            throw new AssertionError((Object)String.format("%sexpected:<%s> to pass validation", ValidationAssertions.toMessageString(message), object));
        }
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation, String message) {
        Set<ConstraintViolation<T>> violations = ValidationAssertions.validate(object);
        for (ConstraintViolation<T> violation : violations) {
            if (!annotation.isInstance(violation.getConstraintDescriptor().getAnnotation()) || !violation.getPropertyPath().toString().equals(field)) continue;
            if (!violation.getMessage().equals(expectedErrorMessage)) {
                throw new AssertionError((Object)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s', but message was '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, message, annotation.getName(), expectedErrorMessage, violation.getMessage()));
            }
            return;
        }
        throw new AssertionError((Object)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, object, annotation.getName(), expectedErrorMessage));
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation) {
        ValidationAssertions.assertFailsValidation(object, field, expectedErrorMessage, annotation, null);
    }

    private static String toMessageString(String message) {
        return message == null ? "" : message + " ";
    }
}

