/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.testing.EquivalenceAssertionError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class EquivalenceTester {
    private EquivalenceTester() {
    }

    @Deprecated
    public static void check(Collection<?> ... equivalenceClasses) {
        EquivalenceCheck<Object> tester = EquivalenceTester.equivalenceTester();
        for (Collection<?> equivalenceClass : equivalenceClasses) {
            tester.addEquivalentGroup(equivalenceClass, new Object[0]);
        }
        tester.check();
    }

    public static <T> EquivalenceCheck<T> equivalenceTester() {
        return new EquivalenceCheck();
    }

    @SafeVarargs
    @Deprecated
    public static <T extends Comparable<T>> void checkComparison(Iterable<T> initialGroup, Iterable<T> greaterGroup, Iterable<T> ... moreGreaterGroup) {
        ComparisonCheck<T> tester = EquivalenceTester.comparisonTester().addLesserGroup(initialGroup).addGreaterGroup(greaterGroup);
        for (Iterable<T> equivalenceClass : moreGreaterGroup) {
            tester.addGreaterGroup(equivalenceClass);
        }
        tester.check();
    }

    public static InitialComparisonCheck comparisonTester() {
        return new InitialComparisonCheck();
    }

    public static class EquivalenceCheck<T> {
        private final List<List<T>> equivalenceClasses = new ArrayList<List<T>>();

        private EquivalenceCheck() {
        }

        @SafeVarargs
        public final EquivalenceCheck<T> addEquivalentGroup(T value, T ... moreValues) {
            this.equivalenceClasses.add(Lists.asList(value, (Object[])moreValues));
            return this;
        }

        public EquivalenceCheck<T> addEquivalentGroup(Iterable<T> objects) {
            this.equivalenceClasses.add(Lists.newArrayList(objects));
            return this;
        }

        public void check() {
            List<ElementCheckFailure> failures = this.checkEquivalence();
            if (!failures.isEmpty()) {
                throw new EquivalenceAssertionError(failures);
            }
        }

        private List<ElementCheckFailure> checkEquivalence() {
            int elementNumber;
            ImmutableList.Builder errors = new ImmutableList.Builder();
            int classNumber = 0;
            for (List<T> congruenceClass : this.equivalenceClasses) {
                elementNumber = 0;
                for (Object element : congruenceClass) {
                    try {
                        if (element.equals(null)) {
                            errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.EQUAL_TO_NULL, classNumber, elementNumber, element));
                        }
                    }
                    catch (NullPointerException e) {
                        errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.EQUAL_NULL_EXCEPTION, classNumber, elementNumber, element));
                    }
                    if (element instanceof Comparable) {
                        try {
                            ((Comparable)element).compareTo(null);
                            errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.COMPARE_EQUAL_TO_NULL, classNumber, elementNumber, element));
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    try {
                        if (element.equals(new OtherClass())) {
                            errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.EQUAL_TO_UNRELATED_CLASS, classNumber, elementNumber, element));
                        }
                    }
                    catch (ClassCastException e) {
                        errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.EQUAL_TO_UNRELATED_CLASS_CLASS_CAST_EXCEPTION, classNumber, elementNumber, element));
                    }
                    ++elementNumber;
                }
                ++classNumber;
            }
            classNumber = 0;
            for (List<T> congruenceClass : this.equivalenceClasses) {
                elementNumber = 0;
                for (Object element : congruenceClass) {
                    if (!element.equals(element)) {
                        errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.NOT_REFLEXIVE, classNumber, elementNumber, element));
                    }
                    if (!EquivalenceCheck.doesCompareReturn0(element, element)) {
                        errors.add((Object)new ElementCheckFailure(EquivalenceFailureType.COMPARE_NOT_REFLEXIVE, classNumber, elementNumber, element));
                    }
                    ++elementNumber;
                }
                ++classNumber;
            }
            classNumber = 0;
            for (List<T> congruenceClass : this.equivalenceClasses) {
                for (int primaryElementNumber = 0; primaryElementNumber < congruenceClass.size(); ++primaryElementNumber) {
                    T primary = congruenceClass.get(primaryElementNumber);
                    for (int secondaryElementNumber = primaryElementNumber + 1; secondaryElementNumber < congruenceClass.size(); ++secondaryElementNumber) {
                        T secondary = congruenceClass.get(secondaryElementNumber);
                        if (!primary.equals(secondary)) {
                            errors.add((Object)new PairCheckFailure(EquivalenceFailureType.NOT_EQUAL, classNumber, primaryElementNumber, primary, classNumber, secondaryElementNumber, secondary));
                        }
                        if (!secondary.equals(primary)) {
                            errors.add((Object)new PairCheckFailure(EquivalenceFailureType.NOT_EQUAL, classNumber, secondaryElementNumber, secondary, classNumber, primaryElementNumber, primary));
                        }
                        try {
                            if (!EquivalenceCheck.doesCompareReturn0(primary, secondary)) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_NOT_EQUAL, classNumber, primaryElementNumber, primary, classNumber, secondaryElementNumber, secondary));
                            }
                        }
                        catch (ClassCastException e) {
                            errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_CLASS_CAST_EXCEPTION, classNumber, primaryElementNumber, primary, classNumber, secondaryElementNumber, secondary));
                        }
                        try {
                            if (!EquivalenceCheck.doesCompareReturn0(secondary, primary)) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_NOT_EQUAL, classNumber, secondaryElementNumber, secondary, classNumber, primaryElementNumber, primary));
                            }
                        }
                        catch (ClassCastException e) {
                            errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_CLASS_CAST_EXCEPTION, classNumber, secondaryElementNumber, secondary, classNumber, primaryElementNumber, primary));
                        }
                        if (primary.hashCode() == secondary.hashCode()) continue;
                        errors.add((Object)new PairCheckFailure(EquivalenceFailureType.HASH_CODE_NOT_SAME, classNumber, primaryElementNumber, primary, classNumber, secondaryElementNumber, secondary));
                    }
                }
                ++classNumber;
            }
            for (int primaryClassNumber = 0; primaryClassNumber < this.equivalenceClasses.size(); ++primaryClassNumber) {
                List<T> primaryCongruenceClass = this.equivalenceClasses.get(primaryClassNumber);
                for (int secondaryClassNumber = primaryClassNumber + 1; secondaryClassNumber < this.equivalenceClasses.size(); ++secondaryClassNumber) {
                    List<T> secondaryCongruenceClass = this.equivalenceClasses.get(secondaryClassNumber);
                    int primaryElementNumber = 0;
                    for (T primary : primaryCongruenceClass) {
                        int secondaryElementNumber = 0;
                        for (T secondary : secondaryCongruenceClass) {
                            if (primary.equals(secondary)) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.EQUAL, primaryClassNumber, primaryElementNumber, primary, secondaryClassNumber, secondaryElementNumber, secondary));
                            }
                            if (secondary.equals(primary)) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.EQUAL, secondaryClassNumber, secondaryElementNumber, secondary, primaryClassNumber, primaryElementNumber, primary));
                            }
                            try {
                                if (!EquivalenceCheck.doesCompareNotReturn0(primary, secondary)) {
                                    errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_EQUAL, primaryClassNumber, primaryElementNumber, primary, secondaryClassNumber, secondaryElementNumber, secondary));
                                }
                            }
                            catch (ClassCastException e) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_CLASS_CAST_EXCEPTION, primaryClassNumber, primaryElementNumber, primary, secondaryClassNumber, secondaryElementNumber, secondary));
                            }
                            try {
                                if (!EquivalenceCheck.doesCompareNotReturn0(secondary, primary)) {
                                    errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_EQUAL, secondaryClassNumber, secondaryElementNumber, secondary, primaryClassNumber, primaryElementNumber, primary));
                                }
                            }
                            catch (ClassCastException e) {
                                errors.add((Object)new PairCheckFailure(EquivalenceFailureType.COMPARE_CLASS_CAST_EXCEPTION, secondaryClassNumber, secondaryElementNumber, secondary, primaryClassNumber, primaryElementNumber, primary));
                            }
                            ++secondaryElementNumber;
                        }
                        ++primaryElementNumber;
                    }
                }
            }
            return errors.build();
        }

        private static <T> boolean doesCompareReturn0(T e1, T e2) {
            if (!(e1 instanceof Comparable)) {
                return true;
            }
            Comparable comparable = (Comparable)e1;
            return comparable.compareTo(e2) == 0;
        }

        private static <T> boolean doesCompareNotReturn0(T e1, T e2) {
            if (!(e1 instanceof Comparable)) {
                return true;
            }
            Comparable comparable = (Comparable)e1;
            return comparable.compareTo(e2) != 0;
        }

        private static class OtherClass {
            private OtherClass() {
            }
        }
    }

    public static class InitialComparisonCheck {
        private InitialComparisonCheck() {
        }

        @SafeVarargs
        public final <T extends Comparable<T>> ComparisonCheck<T> addLesserGroup(T value, T ... moreValues) {
            ComparisonCheck comparisonCheck = new ComparisonCheck();
            comparisonCheck.addGreaterGroup(Lists.asList(value, (Object[])moreValues));
            return comparisonCheck;
        }

        public <T extends Comparable<T>> ComparisonCheck<T> addLesserGroup(Iterable<T> objects) {
            ComparisonCheck<T> comparisonCheck = new ComparisonCheck<T>();
            comparisonCheck.addGreaterGroup(objects);
            return comparisonCheck;
        }
    }

    public static class ComparisonCheck<T extends Comparable<T>> {
        private final EquivalenceCheck<T> equivalence = new EquivalenceCheck();

        private ComparisonCheck() {
        }

        @SafeVarargs
        public final ComparisonCheck<T> addGreaterGroup(T value, T ... moreValues) {
            this.equivalence.addEquivalentGroup(Lists.asList(value, (Object[])moreValues));
            return this;
        }

        public ComparisonCheck<T> addGreaterGroup(Iterable<T> objects) {
            this.equivalence.addEquivalentGroup(objects);
            return this;
        }

        public void check() {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            builder.addAll(this.equivalence.checkEquivalence());
            List equivalenceClasses = this.equivalence.equivalenceClasses;
            for (int lesserClassNumber = 0; lesserClassNumber < equivalenceClasses.size(); ++lesserClassNumber) {
                List lesserBag = equivalenceClasses.get(lesserClassNumber);
                for (int greaterClassNumber = lesserClassNumber + 1; greaterClassNumber < equivalenceClasses.size(); ++greaterClassNumber) {
                    List greaterBag = equivalenceClasses.get(greaterClassNumber);
                    for (int lesserElementNumber = 0; lesserElementNumber < lesserBag.size(); ++lesserElementNumber) {
                        Comparable lesser = (Comparable)lesserBag.get(lesserElementNumber);
                        for (int greaterElementNumber = 0; greaterElementNumber < greaterBag.size(); ++greaterElementNumber) {
                            Comparable greater = (Comparable)greaterBag.get(greaterElementNumber);
                            try {
                                if (lesser.compareTo(greater) >= 0) {
                                    builder.add((Object)new PairCheckFailure(EquivalenceFailureType.NOT_LESS_THAN, lesserClassNumber, lesserElementNumber, lesser, greaterClassNumber, greaterElementNumber, greater));
                                }
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                            try {
                                if (greater.compareTo(lesser) > 0) continue;
                                builder.add((Object)new PairCheckFailure(EquivalenceFailureType.NOT_GREATER_THAN, greaterClassNumber, greaterElementNumber, greater, lesserClassNumber, lesserElementNumber, lesser));
                                continue;
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            ImmutableList failures = builder.build();
            if (!failures.isEmpty()) {
                throw new EquivalenceAssertionError((Iterable<ElementCheckFailure>)failures);
            }
        }
    }

    public static class PairCheckFailure
    extends ElementCheckFailure {
        private final int secondaryClassNumber;
        private final int secondaryElementNumber;
        private final Object secondaryObject;

        public PairCheckFailure(EquivalenceFailureType type, int primaryClassNumber, int primaryElementNumber, Object primaryObject, int secondaryClassNumber, int secondaryElementNumber, Object secondaryObject) {
            super(type, primaryClassNumber, primaryElementNumber, primaryObject);
            this.secondaryClassNumber = secondaryClassNumber;
            this.secondaryElementNumber = secondaryElementNumber;
            this.secondaryObject = secondaryObject;
        }

        public int getSecondaryClassNumber() {
            return this.secondaryClassNumber;
        }

        public int getSecondaryElementNumber() {
            return this.secondaryElementNumber;
        }

        @Override
        public String toString() {
            return String.format(this.type.getMessage(), this.primaryClassNumber, this.primaryElementNumber, this.primaryObject, this.secondaryClassNumber, this.secondaryElementNumber, this.secondaryObject);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PairCheckFailure that = (PairCheckFailure)o;
            if (this.primaryClassNumber != that.primaryClassNumber) {
                return false;
            }
            if (this.primaryElementNumber != that.primaryElementNumber) {
                return false;
            }
            if (this.primaryObject != that.primaryObject && !this.primaryObject.equals(that.primaryObject)) {
                return false;
            }
            if (this.secondaryClassNumber != that.secondaryClassNumber) {
                return false;
            }
            if (this.secondaryElementNumber != that.secondaryElementNumber) {
                return false;
            }
            if (this.secondaryObject != that.secondaryObject && !this.secondaryObject.equals(that.secondaryObject)) {
                return false;
            }
            return this.type.equals((Object)that.type);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.primaryClassNumber;
            result = 31 * result + this.primaryElementNumber;
            result = 31 * result + this.primaryObject.hashCode();
            result = 31 * result + this.secondaryClassNumber;
            result = 31 * result + this.secondaryElementNumber;
            result = 31 * result + this.secondaryObject.hashCode();
            return result;
        }
    }

    public static class ElementCheckFailure {
        protected final EquivalenceFailureType type;
        protected final int primaryClassNumber;
        protected final int primaryElementNumber;
        protected final Object primaryObject;

        public ElementCheckFailure(EquivalenceFailureType type, int primaryClassNumber, int primaryElementNumber, Object primaryObject) {
            Objects.requireNonNull(type, "type is null");
            this.type = type;
            this.primaryClassNumber = primaryClassNumber;
            this.primaryElementNumber = primaryElementNumber;
            this.primaryObject = primaryObject;
        }

        public EquivalenceFailureType getType() {
            return this.type;
        }

        public int getPrimaryClassNumber() {
            return this.primaryClassNumber;
        }

        public int getPrimaryElementNumber() {
            return this.primaryElementNumber;
        }

        public String toString() {
            return String.format(this.type.getMessage(), this.primaryClassNumber, this.primaryElementNumber, this.primaryObject);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementCheckFailure that = (ElementCheckFailure)o;
            if (this.primaryClassNumber != that.primaryClassNumber) {
                return false;
            }
            if (this.primaryElementNumber != that.primaryElementNumber) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
            return this.primaryObject == that.primaryObject || this.primaryObject.equals(that.primaryObject);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.primaryClassNumber;
            result = 31 * result + this.primaryElementNumber;
            result = 31 * result + this.primaryObject.hashCode();
            return result;
        }
    }

    public static enum EquivalenceFailureType {
        EQUAL_TO_NULL("Element (%d, %d):<%s> returns true when compared to null via equals()"),
        EQUAL_NULL_EXCEPTION("Element (%d, %d):<%s> throws NullPointerException when when compared to null via equals()"),
        COMPARE_EQUAL_TO_NULL("Element (%d, %d):<%s> implements Comparable but does not throw NullPointerException when compared to null"),
        EQUAL_TO_UNRELATED_CLASS("Element (%d, %d):<%s> returns true when compared to an unrelated class via equals()"),
        EQUAL_TO_UNRELATED_CLASS_CLASS_CAST_EXCEPTION("Element (%d, %d):<%s> throws a ClassCastException when compared to an unrelated class via equals()"),
        NOT_REFLEXIVE("Element (%d, %d):<%s> is not equal to itself when compared via equals()"),
        COMPARE_NOT_REFLEXIVE("Element (%d, %d):<%s> implements Comparable but compare does not return 0 when compared to itself"),
        NOT_EQUAL("Element (%d, %d):<%s> is not equal to element (%d, %d):<%s> when compared via equals()"),
        COMPARE_NOT_EQUAL("Element (%d, %d):<%s> is not equal to element (%d, %d):<%s> when compared via compareTo(T)"),
        COMPARE_CLASS_CAST_EXCEPTION("Element (%d, %d):<%s> throws a ClassCastException when compared to element (%d, %d):<%s> via compareTo(T)"),
        HASH_CODE_NOT_SAME("Elements (%d, %d):<%s> and (%d, %d):<%s> have different hash codes"),
        EQUAL("Element (%d, %d):<%s> is equal to element (%d, %d):<%s> when compared via equals()"),
        COMPARE_EQUAL("Element (%d, %d):<%s> implements Comparable and returns 0 when compared to element (%d, %d):<%s>"),
        NOT_LESS_THAN("Element (%d, %d):<%s> is not less than (%d, %d):<%s>"),
        NOT_GREATER_THAN("Element (%d, %d):<%s> is not greater than (%d, %d):<%s>");

        private final String message;

        private EquivalenceFailureType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

