/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tracing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public final class SpanSerialization {
    private SpanSerialization() {
    }

    public static class SpanDeserializer
    extends StdDeserializer<Span> {
        private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};
        private final TextMapPropagator propagator;

        @Inject
        public SpanDeserializer(OpenTelemetry openTelemetry) {
            super(Span.class);
            this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
        }

        public Span deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Map map = (Map)jsonParser.readValueAs(MAP_TYPE);
            Context context = this.propagator.extract(Context.root(), (Object)map, (TextMapGetter)MapTextMapGetter.INSTANCE);
            return Span.fromContext((Context)context);
        }

        private static class MapTextMapGetter
        implements TextMapGetter<Map<String, String>> {
            public static final MapTextMapGetter INSTANCE = new MapTextMapGetter();

            private MapTextMapGetter() {
            }

            public Iterable<String> keys(Map<String, String> map) {
                return map.keySet();
            }

            public String get(Map<String, String> map, String key) {
                return Objects.requireNonNull(map).get(key);
            }
        }
    }

    public static class SpanSerializer
    extends StdSerializer<Span> {
        private final TextMapPropagator propagator;

        @Inject
        public SpanSerializer(OpenTelemetry openTelemetry) {
            super(Span.class);
            this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
        }

        public void serialize(Span span, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            Context context = Context.root().with((ImplicitContextKeyed)span);
            LinkedHashMap map = new LinkedHashMap();
            this.propagator.inject(context, map, Map::put);
            jsonGenerator.writeObject(map);
        }
    }
}

