/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tracing;

import com.google.inject.Binder;
import com.google.inject.Provides;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.json.JsonBinder;
import io.airlift.tracing.OpenTelemetryModule;
import io.airlift.tracing.SpanSerialization;
import io.airlift.tracing.TracingEnabledConfig;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.Objects;

public class TracingModule
extends AbstractConfigurationAwareModule {
    private final String serviceName;
    private final String serviceVersion;

    public TracingModule(String serviceName, String serviceVersion) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName is null");
        this.serviceVersion = Objects.requireNonNull(serviceVersion, "serviceVersion is null");
    }

    protected void setup(Binder binder) {
        if (((TracingEnabledConfig)this.buildConfigObject(TracingEnabledConfig.class)).isEnabled()) {
            this.install(new OpenTelemetryModule(this.serviceName, this.serviceVersion));
        } else {
            binder.bind(OpenTelemetry.class).toInstance((Object)OpenTelemetry.noop());
        }
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Span.class).to(SpanSerialization.SpanSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Span.class).to(SpanSerialization.SpanDeserializer.class);
    }

    @Provides
    public Tracer createTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(this.serviceName);
    }
}

