/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tracing;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.node.NodeInfo;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.semconv.ResourceAttributes;
import java.util.Objects;
import java.util.Set;

public class OpenTelemetryModule
implements Module {
    private static final String NODE_ANNOTATION_PREFIX = "io.airlift.node";
    private final String serviceName;
    private final String serviceVersion;

    public OpenTelemetryModule(String serviceName, String serviceVersion) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName is null");
        this.serviceVersion = Objects.requireNonNull(serviceVersion, "serviceVersion is null");
    }

    public void configure(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, SpanProcessor.class);
    }

    @Provides
    @Singleton
    public OpenTelemetry createOpenTelemetry(NodeInfo nodeInfo, Set<SpanProcessor> spanProcessors) {
        if (spanProcessors.isEmpty()) {
            return OpenTelemetry.noop();
        }
        AttributesBuilder attributes = Attributes.builder().put(ResourceAttributes.SERVICE_NAME, (Object)this.serviceName).put(ResourceAttributes.SERVICE_VERSION, (Object)this.serviceVersion).put(ResourceAttributes.SERVICE_INSTANCE_ID, (Object)nodeInfo.getNodeId()).put(ResourceAttributes.DEPLOYMENT_ENVIRONMENT, (Object)nodeInfo.getEnvironment()).put(ResourceAttributes.PROCESS_RUNTIME_NAME, (Object)System.getProperty("java.runtime.name")).put(ResourceAttributes.PROCESS_RUNTIME_VERSION, (Object)System.getProperty("java.runtime.version")).put(ResourceAttributes.PROCESS_RUNTIME_DESCRIPTION, (Object)OpenTelemetryModule.processRuntime()).put(ResourceAttributes.OS_TYPE, (Object)OpenTelemetryModule.osType()).put(ResourceAttributes.OS_NAME, (Object)StandardSystemProperty.OS_NAME.value()).put(ResourceAttributes.OS_VERSION, (Object)StandardSystemProperty.OS_VERSION.value()).put(ResourceAttributes.HOST_ARCH, (Object)OpenTelemetryModule.hostArch());
        nodeInfo.getAnnotations().forEach((key, value) -> attributes.put(String.format("%s.%s", NODE_ANNOTATION_PREFIX, key), value));
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)attributes.build()));
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SpanProcessor.composite(spanProcessors)).setResource(resource).build();
        return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
    }

    private static String processRuntime() {
        String vendor = StandardSystemProperty.JAVA_VM_VENDOR.value();
        String name = StandardSystemProperty.JAVA_VM_NAME.value();
        String version = StandardSystemProperty.JAVA_VM_VERSION.value();
        if (vendor == null && name == null && version == null) {
            return null;
        }
        return "%s %s %s".formatted(vendor, name, version);
    }

    private static String osType() {
        return switch (Strings.nullToEmpty((String)StandardSystemProperty.OS_NAME.value())) {
            case "Linux" -> "linux";
            case "Mac OS X" -> "darwin";
            default -> null;
        };
    }

    private static String hostArch() {
        return switch (Strings.nullToEmpty((String)StandardSystemProperty.OS_ARCH.value())) {
            case "amd64", "x86_64" -> "amd64";
            case "aarch64" -> "arm64";
            case "ppc64le" -> "ppc64";
            default -> null;
        };
    }
}

