/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tracing;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.ConfigBinder;
import io.airlift.tracing.OpenTelemetryExporterConfig;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;

public class OpenTelemetryExporterModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(OpenTelemetryExporterConfig.class);
    }

    @ProvidesIntoSet
    public static SpanProcessor createExporter(OpenTelemetryExporterConfig config) {
        return BatchSpanProcessor.builder((SpanExporter)OpenTelemetryExporterModule.createSpanExporter(config)).build();
    }

    static SpanExporter createSpanExporter(OpenTelemetryExporterConfig config) {
        return switch (config.getProtocol()) {
            default -> throw new MatchException(null, null);
            case OpenTelemetryExporterConfig.Protocol.GRPC -> OtlpGrpcSpanExporter.builder().setEndpoint(config.getEndpoint()).build();
            case OpenTelemetryExporterConfig.Protocol.HTTP_PROTOBUF -> OtlpHttpSpanExporter.builder().setEndpoint(config.getEndpoint()).build();
        };
    }
}

