/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.units;

import io.airlift.units.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ThreadCount
implements Comparable<ThreadCount> {
    private static final String PER_CORE_SUFFIX = "C";
    private static final Supplier<Integer> AVAILABLE_PROCESSORS = MachineInfo::getAvailablePhysicalProcessorCount;
    private final int threadCount;

    ThreadCount(int threadCount) {
        Preconditions.checkArgument(threadCount >= 0, "Thread count cannot be negative");
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public static ThreadCount exactValueOf(int value) {
        return new ThreadCount(value);
    }

    public static ThreadCount valueOf(String value) {
        if (value.endsWith(PER_CORE_SUFFIX)) {
            float parsedMultiplier = ThreadCount.parseFloat(value.substring(0, value.lastIndexOf(PER_CORE_SUFFIX)).trim());
            Preconditions.checkArgument(parsedMultiplier > 0.0f, "Thread multiplier cannot be negative");
            float threadCount = parsedMultiplier * (float)AVAILABLE_PROCESSORS.get().intValue();
            Preconditions.checkArgument(threadCount <= 2.1474836E9f, "Thread count is greater than 2^32 - 1");
            return new ThreadCount(Math.round(threadCount));
        }
        return new ThreadCount(ThreadCount.parseInteger(value));
    }

    public static ThreadCount boundedValueOf(String value, String minValue, String maxValue) {
        ThreadCount parsed = ThreadCount.valueOf(value);
        ThreadCount min = ThreadCount.valueOf(minValue);
        ThreadCount max = ThreadCount.valueOf(maxValue);
        if (parsed.compareTo(min) < 0) {
            return min;
        }
        if (parsed.compareTo(max) > 0) {
            return max;
        }
        return parsed;
    }

    private static float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse value '%s' as float", value), e);
        }
    }

    private static int parseInteger(String value) {
        try {
            long parsed = Long.parseLong(value);
            Preconditions.checkArgument(parsed <= Integer.MAX_VALUE, "Thread count is greater than 2^32 - 1");
            return Math.toIntExact(parsed);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse value '%s' as integer", value), e);
        }
    }

    @Override
    public int compareTo(ThreadCount o) {
        return Integer.compare(this.threadCount, o.threadCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadCount that = (ThreadCount)o;
        return this.threadCount == that.threadCount;
    }

    public int hashCode() {
        return this.threadCount;
    }

    public String toString() {
        return this.threadCount == 1 ? "1 thread" : this.threadCount + " threads";
    }

    static final class MachineInfo {
        private static final Path CPU_INFO_PATH = Path.of("/proc/cpuinfo", new String[0]);
        private static volatile int physicalProcessorCount = -1;

        private MachineInfo() {
        }

        public static int getAvailablePhysicalProcessorCount() {
            OptionalInt procInfo;
            int availableProcessorCount;
            if (physicalProcessorCount != -1) {
                return physicalProcessorCount;
            }
            String osArch = System.getProperty("os.arch");
            int totalPhysicalProcessorCount = availableProcessorCount = Runtime.getRuntime().availableProcessors();
            if (("amd64".equals(osArch) || "x86_64".equals(osArch)) && (procInfo = MachineInfo.tryReadFromProcCpuinfo()).isPresent()) {
                totalPhysicalProcessorCount = procInfo.getAsInt();
            }
            physicalProcessorCount = Math.min(totalPhysicalProcessorCount, availableProcessorCount);
            return physicalProcessorCount;
        }

        private static OptionalInt tryReadFromProcCpuinfo() {
            OptionalInt optionalInt;
            block9: {
                if (!Files.exists(CPU_INFO_PATH, new LinkOption[0])) {
                    return OptionalInt.empty();
                }
                Stream<String> lines = Files.lines(CPU_INFO_PATH);
                try {
                    optionalInt = OptionalInt.of(Math.toIntExact(lines.filter(line -> line.matches("^processor\\s+: \\d")).count()));
                    if (lines == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (lines != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return OptionalInt.empty();
                    }
                }
                lines.close();
            }
            return optionalInt;
        }
    }
}

