/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public enum FormatType {
    CSV("csv"),
    JSON("json"),
    JSONL("jsonl");

    public static final String SUPPORTED_FORMAT_TYPES;
    public final String name;

    private FormatType(String name) {
        this.name = name;
    }

    public static FormatType forName(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        for (FormatType ct : FormatType.values()) {
            if (!ct.name.equalsIgnoreCase(name)) continue;
            return ct;
        }
        throw new IllegalArgumentException("Unknown compression type: " + name);
    }

    public static Collection<String> names() {
        return Arrays.stream(FormatType.values()).map(v -> v.name).collect(Collectors.toList());
    }

    static {
        SUPPORTED_FORMAT_TYPES = FormatType.names().stream().map(c -> String.format("'%s'", c)).collect(Collectors.joining(", "));
    }
}

