/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.connect.sink.SinkRecord;

public abstract class OutputWriter
implements AutoCloseable {
    private OutputStream outputStream;
    private Boolean isOutputEmpty;
    private Boolean isClosed;
    private OutputStreamWriter writer;

    public OutputWriter(Collection<OutputField> fields, OutputStream outputStream) {
        this.writer = this.writer(fields);
        this.outputStream = outputStream;
        this.isOutputEmpty = true;
        this.isClosed = false;
    }

    public void writeRecord(SinkRecord record) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        if (!this.isOutputEmpty.booleanValue()) {
            this.writer.writeRecordsSeparator(this.outputStream);
        } else {
            this.writer.startWriting(this.outputStream);
            this.isOutputEmpty = false;
        }
        this.writer.writeOneRecord(this.outputStream, record);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.booleanValue()) {
            try {
                this.writer.stopWriting(this.outputStream);
                this.outputStream.flush();
            }
            finally {
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.isClosed = true;
                }
            }
        }
    }

    protected abstract OutputStreamWriter writer(Collection<OutputField> var1);
}

