/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.OutputWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonOutputFieldComposer;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonOutputStreamWriter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;

public class JsonOutputWriter
extends OutputWriter {
    public JsonOutputWriter(Collection<OutputField> fields, OutputStream outputStream) {
        super(fields, outputStream);
    }

    @Override
    protected OutputStreamWriter writer(Collection<OutputField> fields) {
        return new Builder().addFields(fields).build();
    }

    static final class Builder {
        private final JsonOutputFieldComposer fieldsComposer = new JsonOutputFieldComposer();

        Builder() {
        }

        final Builder addFields(Collection<OutputField> fields) {
            Objects.requireNonNull(fields, "fields cannot be null");
            this.fieldsComposer.addFields(fields);
            return this;
        }

        final JsonOutputStreamWriter build() {
            return new JsonOutputStreamWriter(this.fieldsComposer.fieldBuilders);
        }
    }
}

