/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;

class ValueBuilder
implements OutputFieldBuilder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonConverter converter = new JsonConverter();

    public ValueBuilder() {
        this.converter.configure(Map.of("schemas.enable", false, "converter.type", "value"));
    }

    @Override
    public JsonNode build(SinkRecord record) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        if (record.value() == null) {
            return null;
        }
        return this.objectMapper.readTree(this.converter.fromConnectData(record.topic(), record.valueSchema(), record.value()));
    }
}

