/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.plainwriter;

import io.aiven.kafka.connect.common.output.plainwriter.OutputFieldPlainWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;

public abstract class AbstractValuePlainWriter
implements OutputFieldPlainWriter {
    @Override
    public void write(SinkRecord record, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        Objects.requireNonNull(record.valueSchema(), "value schema cannot be null");
        Objects.requireNonNull(outputStream, "outputStream cannot be null");
        if (record.valueSchema().type() != Schema.Type.BYTES) {
            String msg = String.format("Record value schema type must be %s, %s given", Schema.Type.BYTES, record.valueSchema().type());
            throw new DataException(msg);
        }
        if (record.value() == null) {
            return;
        }
        if (!(record.value() instanceof byte[])) {
            throw new DataException("Value is not a byte array");
        }
        outputStream.write(this.getOutputBytes((byte[])record.value()));
    }

    protected abstract byte[] getOutputBytes(byte[] var1);
}

