/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import io.aiven.kafka.connect.common.config.FilenameTemplateVariable;
import io.aiven.kafka.connect.common.grouper.RecordGrouperFactory;
import io.aiven.kafka.connect.common.templating.Template;
import io.aiven.kafka.connect.common.templating.VariableTemplatePart;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class FilenameTemplateValidator
implements ConfigDef.Validator {
    private static final Map<String, FilenameTemplateVariable.ParameterDescriptor> SUPPORTED_VARIABLE_PARAMETERS = new LinkedHashMap<String, FilenameTemplateVariable.ParameterDescriptor>(){
        {
            this.put(FilenameTemplateVariable.START_OFFSET.name, FilenameTemplateVariable.START_OFFSET.parameterDescriptor);
            this.put(FilenameTemplateVariable.TIMESTAMP.name, FilenameTemplateVariable.TIMESTAMP.parameterDescriptor);
        }
    };
    private final String configName;

    public FilenameTemplateValidator(String configName) {
        this.configName = configName;
    }

    public final void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        assert (value instanceof String);
        String valueStr = (String)value;
        if (valueStr.startsWith(".well-known/acme-challenge")) {
            throw new ConfigException(this.configName, value, "cannot start with '.well-known/acme-challenge'");
        }
        try {
            Template template = Template.of((String)value);
            FilenameTemplateValidator.validateVariables(template.variablesSet());
            this.validateVariableParameters(template.variablesWithNonEmptyParameters());
            FilenameTemplateValidator.validateVariablesWithRequiredParameters(template.variablesWithParameters());
            RecordGrouperFactory.resolveRecordGrouperType(template);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(this.configName, value, e.getMessage());
        }
    }

    private static void validateVariables(Set<String> variables) {
        for (String variable : variables) {
            if (RecordGrouperFactory.ALL_SUPPORTED_VARIABLES.contains(variable)) continue;
            throw new IllegalArgumentException(String.format("unsupported set of template variables, supported sets are: %s", RecordGrouperFactory.SUPPORTED_VARIABLES_LIST));
        }
    }

    public void validateVariableParameters(List<Pair<String, VariableTemplatePart.Parameter>> variablesWithNonEmptyParameters) {
        boolean isVariableParametersSupported = true;
        for (Pair<String, VariableTemplatePart.Parameter> e : variablesWithNonEmptyParameters) {
            String varName = (String)e.getLeft();
            VariableTemplatePart.Parameter varParam = (VariableTemplatePart.Parameter)e.getRight();
            if (!SUPPORTED_VARIABLE_PARAMETERS.containsKey(varName)) continue;
            FilenameTemplateVariable.ParameterDescriptor expectedParameter = SUPPORTED_VARIABLE_PARAMETERS.get(varName);
            if (expectedParameter.values.contains(varParam.value())) continue;
            isVariableParametersSupported = false;
            break;
        }
        if (!isVariableParametersSupported) {
            String supportedParametersSet = SUPPORTED_VARIABLE_PARAMETERS.keySet().stream().map(v -> FilenameTemplateVariable.of(v).description()).collect(Collectors.joining(","));
            throw new IllegalArgumentException(String.format("unsupported set of template variables parameters, supported sets are: %s", supportedParametersSet));
        }
    }

    public static void validateVariablesWithRequiredParameters(List<Pair<String, VariableTemplatePart.Parameter>> variablesWithParameters) {
        for (Pair<String, VariableTemplatePart.Parameter> p : variablesWithParameters) {
            String varName = (String)p.getLeft();
            VariableTemplatePart.Parameter varParam = (VariableTemplatePart.Parameter)p.getRight();
            if (!SUPPORTED_VARIABLE_PARAMETERS.containsKey(varName)) continue;
            FilenameTemplateVariable.ParameterDescriptor expectedParameter = SUPPORTED_VARIABLE_PARAMETERS.get(varName);
            if (!varParam.isEmpty() || !expectedParameter.required) continue;
            throw new IllegalArgumentException(String.format("parameter %s is required for the the variable %s, supported values are: %s", expectedParameter.name, varName, expectedParameter.toString()));
        }
    }
}

