/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public enum FilenameTemplateVariable {
    KEY("key"),
    TOPIC("topic"),
    PARTITION("partition"),
    START_OFFSET("start_offset", new ParameterDescriptor("padding", false, List.of(Boolean.TRUE.toString(), Boolean.FALSE.toString()))),
    TIMESTAMP("timestamp", new ParameterDescriptor("unit", true, List.of("yyyy", "MM", "dd", "HH")));

    public final String name;
    public final ParameterDescriptor parameterDescriptor;

    public String description() {
        return this.parameterDescriptor != ParameterDescriptor.NO_PARAMETER && !this.parameterDescriptor.values.isEmpty() ? String.join((CharSequence)"=", String.join((CharSequence)":", this.name, this.parameterDescriptor.name), this.parameterDescriptor.toString()) : this.name;
    }

    private FilenameTemplateVariable(String name) {
        this(name, ParameterDescriptor.NO_PARAMETER);
    }

    private FilenameTemplateVariable(String name, ParameterDescriptor parameterDescriptor) {
        this.name = name;
        this.parameterDescriptor = parameterDescriptor;
    }

    public static FilenameTemplateVariable of(String name) {
        for (FilenameTemplateVariable v : FilenameTemplateVariable.values()) {
            if (!v.name.equals(name)) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("Unknown filename template variable: %s", name));
    }

    public static class ParameterDescriptor {
        public static final ParameterDescriptor NO_PARAMETER = new ParameterDescriptor("__no_parameter__", false, Collections.emptyList());
        public final String name;
        public final boolean required;
        public List<String> values;

        public ParameterDescriptor(String name, boolean required, List<String> values) {
            this.name = name;
            this.required = required;
            this.values = values;
        }

        public String toString() {
            return !this.values.isEmpty() ? String.join((CharSequence)"|", this.values) : "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterDescriptor)) {
                return false;
            }
            ParameterDescriptor that = (ParameterDescriptor)o;
            return this.required == that.required && Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.required, this.values);
        }
    }
}

