/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public enum OutputFieldEncodingType {
    NONE("none"),
    BASE64("base64");

    public static final String SUPPORTED_FIELD_ENCODING_TYPES;
    public final String name;

    private OutputFieldEncodingType(String name) {
        this.name = name;
    }

    public static OutputFieldEncodingType forName(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        for (OutputFieldEncodingType ofet : OutputFieldEncodingType.values()) {
            if (!ofet.name.equalsIgnoreCase(name)) continue;
            return ofet;
        }
        throw new IllegalArgumentException("Unknown output field encoding type: " + name);
    }

    public static boolean isValidName(String name) {
        return OutputFieldEncodingType.names().contains(name.toLowerCase());
    }

    public static Collection<String> names() {
        return Arrays.stream(OutputFieldEncodingType.values()).map(v -> v.name).collect(Collectors.toList());
    }

    static {
        SUPPORTED_FIELD_ENCODING_TYPES = OutputFieldEncodingType.names().stream().map(c -> String.format("'%s'", c)).collect(Collectors.joining(", "));
    }
}

