/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public interface TimestampSource {
    public ZonedDateTime time();

    public static TimestampSource of(Type extractorType) {
        return TimestampSource.of(ZoneOffset.UTC, extractorType);
    }

    public static TimestampSource of(ZoneId zoneId, Type extractorType) {
        switch (extractorType) {
            case WALLCLOCK: {
                return new WallclockTimestampSource(zoneId);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported timestamp extractor type: %s", new Object[]{extractorType}));
    }

    public static final class WallclockTimestampSource
    implements TimestampSource {
        private final ZoneId zoneId;

        protected WallclockTimestampSource(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public ZonedDateTime time() {
            return ZonedDateTime.now(this.zoneId);
        }
    }

    public static enum Type {
        WALLCLOCK;


        public static Type of(String name) {
            for (Type t : Type.values()) {
                if (!t.name().equalsIgnoreCase(name)) continue;
                return t;
            }
            throw new IllegalArgumentException(String.format("Unknown timestamp source: %s", name));
        }
    }
}

