/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config.validators;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class OutputFieldsValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (Objects.nonNull(value)) {
            List valueList = (List)value;
            if (valueList.isEmpty()) {
                throw new ConfigException(name, (Object)valueList, "cannot be empty");
            }
            for (String fieldName : valueList) {
                if (OutputFieldType.isValidName(fieldName)) continue;
                throw new ConfigException(name, value, "supported values are: " + OutputField.SUPPORTED_OUTPUT_FIELDS);
            }
        }
    }
}

