/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;

class JsonOutputStreamWriter
implements OutputStreamWriter {
    private final Map<String, OutputFieldBuilder> fieldBuilders;
    private final ObjectMapper objectMapper;
    private static final byte[] BATCH_START = "[\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RECORD_SEPARATOR = ",\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] BATCH_END = "\n]".getBytes(StandardCharsets.UTF_8);

    JsonOutputStreamWriter(Map<String, OutputFieldBuilder> fieldBuilders) {
        this.fieldBuilders = fieldBuilders;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }

    @Override
    public void startWriting(OutputStream outputStream) throws IOException {
        outputStream.write(BATCH_START);
    }

    @Override
    public void writeRecordsSeparator(OutputStream outputStream) throws IOException {
        outputStream.write(RECORD_SEPARATOR);
    }

    @Override
    public void writeOneRecord(OutputStream outputStream, SinkRecord record) throws IOException {
        outputStream.write(this.objectMapper.writeValueAsBytes((Object)this.getFields(record)));
    }

    @Override
    public void stopWriting(OutputStream outputStream) throws IOException {
        outputStream.write(BATCH_END);
    }

    private ObjectNode getFields(SinkRecord record) throws IOException {
        Iterator<Map.Entry<String, OutputFieldBuilder>> writerIter = this.fieldBuilders.entrySet().iterator();
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        while (writerIter.hasNext()) {
            this.writeEntry(writerIter.next(), record, root);
        }
        return root;
    }

    private void writeEntry(Map.Entry<String, OutputFieldBuilder> entry, SinkRecord record, ObjectNode root) throws IOException {
        JsonNode node = entry.getValue().build(record);
        root.set(entry.getKey(), node);
    }
}

