/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.parquet;

import io.aiven.kafka.connect.common.config.OutputField;
import io.confluent.connect.avro.AvroData;
import java.util.Collection;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParquetSchemaBuilder {
    private final Logger logger = LoggerFactory.getLogger(ParquetSchemaBuilder.class);
    private final Collection<OutputField> fields;
    private final AvroData avroData;

    ParquetSchemaBuilder(Collection<OutputField> fields, AvroData avroData) {
        this.fields = fields;
        this.avroData = avroData;
    }

    public Schema buildSchema(SinkRecord record) {
        Objects.requireNonNull(record, "record");
        if (Objects.isNull(record.keySchema())) {
            throw new DataException("Record key without schema");
        }
        if (Objects.isNull(record.valueSchema())) {
            throw new DataException("Record value without schema");
        }
        this.logger.debug("Create schema for record");
        this.logger.debug("Record Key Schema {}", (Object)record.keySchema());
        this.logger.debug("Record Value Schema {}", (Object)record.valueSchema());
        return this.avroSchemaFor(record);
    }

    private Schema headersSchema(SinkRecord record) {
        if (record.headers().isEmpty()) {
            return (Schema)SchemaBuilder.builder().nullType();
        }
        org.apache.kafka.connect.data.Schema headerSchema = null;
        for (Header h : record.headers()) {
            if (Objects.isNull(h.schema())) {
                throw new DataException("Header " + h + " without schema");
            }
            if (Objects.isNull(headerSchema)) {
                headerSchema = h.schema();
                continue;
            }
            if (headerSchema.type() == h.schema().type()) continue;
            throw new DataException("Header schema " + h.schema() + " is not the same as " + headerSchema);
        }
        return (Schema)SchemaBuilder.map().values(this.avroData.fromConnectSchema(headerSchema));
    }

    private Schema avroSchemaFor(SinkRecord record) {
        SchemaBuilder.FieldAssembler schemaFields = SchemaBuilder.builder((String)"io.aiven.parquet.output.schema").record("connector_records").fields();
        for (OutputField f : this.fields) {
            Schema schema = this.outputFieldSchema(f, record);
            schemaFields.name(f.getFieldType().name).type(schema).noDefault();
        }
        return (Schema)schemaFields.endRecord();
    }

    private Schema outputFieldSchema(OutputField field, SinkRecord record) {
        switch (field.getFieldType()) {
            case KEY: {
                return this.avroData.fromConnectSchema(record.keySchema());
            }
            case OFFSET: 
            case TIMESTAMP: {
                return (Schema)SchemaBuilder.builder().longType();
            }
            case VALUE: {
                return this.avroData.fromConnectSchema(record.valueSchema());
            }
            case HEADERS: {
                return this.headersSchema(record);
            }
        }
        throw new ConnectException("Unknown field type " + field);
    }
}

