/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.parquet;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import io.confluent.connect.avro.AvroData;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SinkRecordConverter {
    private final Logger logger = LoggerFactory.getLogger(SinkRecordConverter.class);
    private final Collection<OutputField> fields;
    private final AvroData avroData;

    SinkRecordConverter(Collection<OutputField> fields, AvroData avroData) {
        this.fields = fields;
        this.avroData = avroData;
    }

    public GenericRecord convert(SinkRecord record, Schema schema) {
        this.logger.debug("Convert record {} for schema {}", (Object)record, (Object)schema);
        return this.createRecord(schema, record);
    }

    private GenericRecord createRecord(Schema schema, SinkRecord record) {
        GenericData.Record avroRecord = new GenericData.Record(schema);
        for (OutputField f : this.fields) {
            Object fieldValue = this.getRecordValueFor(f.getFieldType(), record);
            avroRecord.put(f.getFieldType().name, fieldValue);
        }
        return avroRecord;
    }

    private Object getRecordValueFor(OutputFieldType fieldType, SinkRecord record) {
        switch (fieldType) {
            case KEY: {
                return this.fromConnectData(record.keySchema(), record.key());
            }
            case VALUE: {
                return this.fromConnectData(record.valueSchema(), record.value());
            }
            case OFFSET: {
                return record.kafkaOffset();
            }
            case TIMESTAMP: {
                return record.timestamp();
            }
            case HEADERS: {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                for (Header h : record.headers()) {
                    String k = h.key();
                    Object v = this.fromConnectData(h.schema(), h.value());
                    headers.put(k, v);
                }
                return headers;
            }
        }
        throw new ConnectException("Unsupported output field: " + fieldType);
    }

    private Object fromConnectData(org.apache.kafka.connect.data.Schema schema, Object value) {
        Object avroDataValue = this.avroData.fromConnectData(schema, value);
        if (avroDataValue instanceof NonRecordContainer) {
            return ((NonRecordContainer)avroDataValue).getValue();
        }
        return avroDataValue;
    }
}

