/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.templating;

import io.aiven.kafka.connect.common.templating.TemplatePart;
import java.util.Objects;

public class VariableTemplatePart
implements TemplatePart {
    private final String variableName;
    private final Parameter parameter;
    private final String originalPlaceholder;

    protected VariableTemplatePart(String variableName, String originalPlaceholder) {
        this(variableName, Parameter.EMPTY, originalPlaceholder);
    }

    protected VariableTemplatePart(String variableName, Parameter parameter, String originalPlaceholder) {
        this.variableName = variableName;
        this.parameter = parameter;
        this.originalPlaceholder = originalPlaceholder;
    }

    public final String variableName() {
        return this.variableName;
    }

    public final Parameter parameter() {
        return this.parameter;
    }

    public final String originalPlaceholder() {
        return this.originalPlaceholder;
    }

    public static final class Parameter {
        public static final Parameter EMPTY = new Parameter("__EMPTY__", "__NO_VALUE__");
        private final String name;
        private final String value;

        private Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public final Boolean asBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        public static Parameter of(String name, String value) {
            if (Objects.isNull(name) && Objects.isNull(value)) {
                return EMPTY;
            }
            Objects.requireNonNull(name, "name has not been set");
            Objects.requireNonNull(value, "value has not been set");
            return new Parameter(name, value);
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.name, parameter.name) && Objects.equals(this.value, parameter.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }
}

