/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.grouper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.aiven.kafka.connect.common.config.AivenCommonConfig;
import io.aiven.kafka.connect.common.config.FilenameTemplateVariable;
import io.aiven.kafka.connect.common.config.FormatType;
import io.aiven.kafka.connect.common.grouper.KeyAndTopicPartitionRecordGrouper;
import io.aiven.kafka.connect.common.grouper.KeyRecordGrouper;
import io.aiven.kafka.connect.common.grouper.RecordGrouper;
import io.aiven.kafka.connect.common.grouper.SchemaBasedTopicPartitionRecordGrouper;
import io.aiven.kafka.connect.common.grouper.TopicPartitionRecordGrouper;
import io.aiven.kafka.connect.common.templating.Template;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class RecordGrouperFactory {
    public static final String KEY_RECORD = KeyRecordGrouper.class.getName();
    public static final String TOPIC_PARTITION_RECORD = TopicPartitionRecordGrouper.class.getName();
    public static final String KEY_TOPIC_PARTITION_RECORD = KeyAndTopicPartitionRecordGrouper.class.getName();
    public static final Map<String, List<Pair<String, Boolean>>> SUPPORTED_VARIABLES = new LinkedHashMap<String, List<Pair<String, Boolean>>>(){
        {
            this.put(TOPIC_PARTITION_RECORD, List.of(Pair.of((Object)FilenameTemplateVariable.TOPIC.name, (Object)true), Pair.of((Object)FilenameTemplateVariable.PARTITION.name, (Object)true), Pair.of((Object)FilenameTemplateVariable.START_OFFSET.name, (Object)true), Pair.of((Object)FilenameTemplateVariable.TIMESTAMP.name, (Object)false)));
            this.put(KEY_RECORD, List.of(Pair.of((Object)FilenameTemplateVariable.KEY.name, (Object)true)));
            this.put(KEY_TOPIC_PARTITION_RECORD, List.of(Pair.of((Object)FilenameTemplateVariable.KEY.name, (Object)true), Pair.of((Object)FilenameTemplateVariable.TOPIC.name, (Object)false), Pair.of((Object)FilenameTemplateVariable.PARTITION.name, (Object)false)));
        }
    };
    public static final List<String> ALL_SUPPORTED_VARIABLES = SUPPORTED_VARIABLES.values().stream().flatMap(Collection::stream).map(Pair::getLeft).collect(Collectors.toList());
    private static final Set<String> KEY_RECORD_REQUIRED_VARS = SUPPORTED_VARIABLES.get(KEY_RECORD).stream().filter(Pair::getRight).map(Pair::getLeft).collect(Collectors.toSet());
    private static final Set<String> TOPIC_PARTITION_RECORD_REQUIRED_VARS = SUPPORTED_VARIABLES.get(TOPIC_PARTITION_RECORD).stream().filter(Pair::getRight).map(Pair::getLeft).collect(Collectors.toSet());
    private static final Set<String> KEY_TOPIC_PARTITION_RECORD_REQUIRED_VARS = SUPPORTED_VARIABLES.get(KEY_TOPIC_PARTITION_RECORD).stream().filter(Pair::getRight).map(Pair::getLeft).collect(Collectors.toSet());
    private static final Set<String> TOPIC_PARTITION_RECORD_OPT_VARS = SUPPORTED_VARIABLES.get(TOPIC_PARTITION_RECORD).stream().filter(p -> (Boolean)p.getRight() == false).map(Pair::getLeft).collect(Collectors.toSet());
    private static final Set<String> KEY_TOPIC_PARTITION_RECORD_OPT_VARS = SUPPORTED_VARIABLES.get(KEY_TOPIC_PARTITION_RECORD).stream().filter(p -> (Boolean)p.getRight() == false).map(Pair::getLeft).collect(Collectors.toSet());
    public static final String SUPPORTED_VARIABLES_LIST = SUPPORTED_VARIABLES.values().stream().map(v -> v.stream().map(Pair::getLeft).collect(Collectors.joining(","))).collect(Collectors.joining("; "));

    private RecordGrouperFactory() {
    }

    public static String resolveRecordGrouperType(Template template) {
        Set<String> variables = template.variablesSet();
        if (RecordGrouperFactory.isByKeyRecord(variables)) {
            return KEY_RECORD;
        }
        if (RecordGrouperFactory.isByTopicPartitionKeyRecord(variables)) {
            return KEY_TOPIC_PARTITION_RECORD;
        }
        if (RecordGrouperFactory.isByTopicPartitionRecord(variables)) {
            return TOPIC_PARTITION_RECORD;
        }
        throw new IllegalArgumentException(String.format("unsupported set of template variables, supported sets are: %s", SUPPORTED_VARIABLES_LIST));
    }

    public static RecordGrouper newRecordGrouper(AivenCommonConfig config) {
        Template fileNameTemplate = config.getFilenameTemplate();
        String grType = RecordGrouperFactory.resolveRecordGrouperType(fileNameTemplate);
        if (KEY_RECORD.equals(grType)) {
            return new KeyRecordGrouper(fileNameTemplate);
        }
        if (KEY_TOPIC_PARTITION_RECORD.equals(grType)) {
            return new KeyAndTopicPartitionRecordGrouper(fileNameTemplate);
        }
        Integer maxRecordsPerFile = config.getMaxRecordsPerFile() != 0 ? Integer.valueOf(config.getMaxRecordsPerFile()) : null;
        return config.getFormatType() == FormatType.PARQUET || config.getFormatType() == FormatType.AVRO ? new SchemaBasedTopicPartitionRecordGrouper(fileNameTemplate, maxRecordsPerFile, config.getFilenameTimestampSource()) : new TopicPartitionRecordGrouper(fileNameTemplate, maxRecordsPerFile, config.getFilenameTimestampSource());
    }

    private static boolean isByKeyRecord(Set<String> vars) {
        return KEY_RECORD_REQUIRED_VARS.equals(vars);
    }

    private static boolean isByTopicPartitionRecord(Set<String> vars) {
        ImmutableSet requiredVars = Sets.intersection(TOPIC_PARTITION_RECORD_REQUIRED_VARS, vars).immutableCopy();
        vars.removeAll((Collection<?>)requiredVars);
        boolean containsRequiredVars = TOPIC_PARTITION_RECORD_REQUIRED_VARS.equals(requiredVars);
        boolean containsOptionalVars = vars.isEmpty() || !Collections.disjoint(TOPIC_PARTITION_RECORD_OPT_VARS, vars);
        return containsRequiredVars && containsOptionalVars;
    }

    private static boolean isByTopicPartitionKeyRecord(Set<String> vars) {
        ImmutableSet requiredVars = Sets.intersection(KEY_TOPIC_PARTITION_RECORD_REQUIRED_VARS, vars).immutableCopy();
        vars.removeAll((Collection<?>)requiredVars);
        boolean containsRequiredVars = KEY_TOPIC_PARTITION_RECORD_REQUIRED_VARS.equals(requiredVars);
        boolean containsOptionalVars = vars.isEmpty() || !Collections.disjoint(KEY_TOPIC_PARTITION_RECORD_OPT_VARS, vars);
        return containsRequiredVars && containsOptionalVars;
    }
}

