/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.avro;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.OutputWriter;
import io.aiven.kafka.connect.common.output.SinkRecordConverter;
import io.aiven.kafka.connect.common.output.avro.AvroConfig;
import io.aiven.kafka.connect.common.output.avro.AvroSchemaBuilder;
import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroOutputWriter
extends OutputWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroOutputWriter.class);
    private final AvroSchemaBuilder avroSchemaBuilder;
    private final SinkRecordConverter sinkRecordConverter;

    public AvroOutputWriter(Collection<OutputField> fields, OutputStream out, Map<String, String> externalConfig, boolean envelopeEnabled) {
        super(out, new OutputStreamWriterStub(), externalConfig);
        AvroData avroData = new AvroData(new AvroDataConfig(externalConfig));
        this.sinkRecordConverter = new SinkRecordConverter(fields, avroData, envelopeEnabled);
        this.avroSchemaBuilder = new AvroSchemaBuilder(fields, avroData, envelopeEnabled);
    }

    @Override
    public void writeRecords(Collection<SinkRecord> sinkRecords) throws IOException {
        AvroConfig avroConfiguration = AvroConfig.createAvroConfiguration(this.externalConfiguration);
        Schema avroSchema = this.avroSchemaBuilder.buildSchema(sinkRecords.iterator().next());
        LOGGER.debug("Record schema is: {}", (Object)avroSchema);
        GenericDatumWriter writer = new GenericDatumWriter(avroSchema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)writer);){
            dataFileWriter.setCodec(avroConfiguration.codecFactory());
            dataFileWriter.create(avroSchema, this.outputStream);
            for (SinkRecord record : sinkRecords) {
                GenericRecord datum = this.sinkRecordConverter.convert(record, avroSchema);
                dataFileWriter.append((Object)datum);
            }
        }
    }

    @Override
    public void writeRecord(SinkRecord record) throws IOException {
        this.writeRecords(List.of(record));
    }

    private static final class OutputStreamWriterStub
    implements OutputStreamWriter {
        private OutputStreamWriterStub() {
        }

        @Override
        public void writeOneRecord(OutputStream outputStream, SinkRecord record) throws IOException {
        }
    }
}

