/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.plainwriter;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputWriter;
import io.aiven.kafka.connect.common.output.plainwriter.Base64ValuePlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.HeadersPlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.KeyPlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.OffsetPlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.OutputFieldPlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.PlainOutputStreamWriter;
import io.aiven.kafka.connect.common.output.plainwriter.TimestampPlainWriter;
import io.aiven.kafka.connect.common.output.plainwriter.ValuePlainWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.errors.ConnectException;

public class PlainOutputWriter
extends OutputWriter {
    public PlainOutputWriter(Collection<OutputField> fields, OutputStream outputStream) {
        super(outputStream, new Builder().addFields(fields).build());
    }

    static final class Builder {
        private final List<OutputFieldPlainWriter> writers = new ArrayList<OutputFieldPlainWriter>();

        Builder() {
        }

        final Builder addFields(Collection<OutputField> fields) {
            Objects.requireNonNull(fields, "fields cannot be null");
            block11: for (OutputField field : fields) {
                switch (field.getFieldType()) {
                    case KEY: {
                        this.writers.add(new KeyPlainWriter());
                        continue block11;
                    }
                    case VALUE: {
                        switch (field.getEncodingType()) {
                            case NONE: {
                                this.writers.add(new ValuePlainWriter());
                                continue block11;
                            }
                            case BASE64: {
                                this.writers.add(new Base64ValuePlainWriter());
                                continue block11;
                            }
                        }
                        throw new ConnectException("Unknown output field encoding type " + String.valueOf((Object)field.getEncodingType()));
                    }
                    case OFFSET: {
                        this.writers.add(new OffsetPlainWriter());
                        continue block11;
                    }
                    case TIMESTAMP: {
                        this.writers.add(new TimestampPlainWriter());
                        continue block11;
                    }
                    case HEADERS: {
                        this.writers.add(new HeadersPlainWriter());
                        continue block11;
                    }
                }
                throw new ConnectException("Unknown output field type " + String.valueOf(field));
            }
            return this;
        }

        final PlainOutputStreamWriter build() {
            return new PlainOutputStreamWriter(this.writers);
        }
    }
}

