/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonLinesOutputStreamWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonOutputFieldComposer;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;

public class JsonLinesOutputWriter
extends OutputWriter {
    public JsonLinesOutputWriter(Collection<OutputField> fields, OutputStream outputStream, boolean envelopeEnabled) {
        super(outputStream, new Builder().addFields(fields).withEnvelopeEnabled(envelopeEnabled).build());
    }

    public JsonLinesOutputWriter(Collection<OutputField> fields, OutputStream outputStream) {
        super(outputStream, new Builder().addFields(fields).build());
    }

    static final class Builder {
        private final JsonOutputFieldComposer fieldsComposer = new JsonOutputFieldComposer();
        private boolean envelopeEnabled = true;

        Builder() {
        }

        final Builder addFields(Collection<OutputField> fields) {
            Objects.requireNonNull(fields, "fields cannot be null");
            this.fieldsComposer.addFields(fields);
            return this;
        }

        final Builder withEnvelopeEnabled(boolean envelopeEnabled) {
            this.envelopeEnabled = envelopeEnabled;
            return this;
        }

        final JsonLinesOutputStreamWriter build() {
            return new JsonLinesOutputStreamWriter(this.fieldsComposer.fieldBuilders, this.envelopeEnabled);
        }
    }
}

