/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public enum OutputFieldType {
    KEY("key"),
    VALUE("value"),
    OFFSET("offset"),
    TIMESTAMP("timestamp"),
    HEADERS("headers");

    public final String name;

    private OutputFieldType(String name) {
        this.name = name;
    }

    public static OutputFieldType forName(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        for (OutputFieldType oft : OutputFieldType.values()) {
            if (!oft.name.equalsIgnoreCase(name)) continue;
            return oft;
        }
        throw new IllegalArgumentException("Unknown output field: " + name);
    }

    public static boolean isValidName(String name) {
        return OutputFieldType.names().contains(name.toLowerCase());
    }

    public static Collection<String> names() {
        return Arrays.stream(OutputFieldType.values()).map(v -> v.name).collect(Collectors.toList());
    }
}

