/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;

class HeaderBuilder
implements OutputFieldBuilder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonConverter converter = new JsonConverter();

    public HeaderBuilder() {
        this.converter.configure(Map.of("schemas.enable", false, "converter.type", "header"));
    }

    @Override
    public JsonNode build(SinkRecord record) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        String topic = record.topic();
        if (record.headers() == null) {
            return null;
        }
        ArrayNode root = JsonNodeFactory.instance.arrayNode();
        for (Header header : record.headers()) {
            ObjectNode headerRoot = JsonNodeFactory.instance.objectNode();
            String key = header.key();
            headerRoot.put("key", key);
            JsonNode headerNode = this.nodeFromHeader(header, topic);
            headerRoot.set("value", headerNode);
            root.add((JsonNode)headerRoot);
        }
        return root;
    }

    private JsonNode nodeFromHeader(Header header, String topic) throws IOException {
        return this.objectMapper.readTree(this.converter.fromConnectHeader(topic, header.key(), header.schema(), header.value()));
    }
}

