/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.testcontainers.fakegcsserver;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class FakeGcsServerContainer
extends GenericContainer<FakeGcsServerContainer> {
    private static final int PORT = 4443;
    public static final String DEFAULT_VERSION = "1.47.4";
    public static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"fsouza/fake-gcs-server:1.47.4");

    public FakeGcsServerContainer() {
        this(DEFAULT_IMAGE_NAME);
    }

    public FakeGcsServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"/bin/fake-gcs-server", "-scheme", "http"}));
        this.addExposedPorts(new int[]{4443});
    }

    public void start() {
        super.start();
        this.updateExternalUrl();
    }

    public String url() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(4443);
    }

    private void updateExternalUrl() {
        HttpResponse<Void> response;
        String modifyExternalUrlRequestUri = this.url() + "/_internal/config";
        String updateExternalUrlJson = "{\"externalUrl\": \"" + this.url() + "\"}";
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(modifyExternalUrlRequestUri)).header("Content-Type", "application/json").PUT(HttpRequest.BodyPublishers.ofString(updateExternalUrlJson)).build();
        try {
            response = HttpClient.newBuilder().build().send(req, HttpResponse.BodyHandlers.discarding());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (response.statusCode() != 200) {
            throw new RuntimeException("error updating fake-gcs-server with external url, response status code " + response.statusCode() + " != 200");
        }
    }
}

