/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import io.allune.bigquery.maven.ConfigurationException;
import io.allune.bigquery.maven.service.BigQueryServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractBigQueryMojo
extends AbstractMojo {
    @Parameter(alias="skip", property="bigquery.skip", defaultValue="false")
    private boolean skip;
    @Parameter(alias="projectId", property="bigquery.projectId", required=true)
    private String projectId;
    @Parameter(alias="datasetName", property="bigquery.datasetName", required=true)
    private String datasetName;
    @Parameter(alias="dataLocation", property="bigquery.dataLocation", defaultValue="EU")
    private String dataLocation;
    @Parameter(alias="credentialsFile", property="bigquery.credentialsFile", required=true)
    private String credentialsFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    private Log log;

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDataLocation() {
        return this.dataLocation;
    }

    public void setDataLocation(String dataLocation) {
        this.dataLocation = dataLocation;
    }

    public String getCredentialsFile() {
        return this.credentialsFile;
    }

    public void setCredentialsFile(String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        if (this.skip) {
            this.log.info((CharSequence)"Skipping BigQuery execution");
            return;
        }
        this.enhanceClassloader();
        BigQueryServiceImpl bigQueryService = BigQueryServiceImpl.builder().bigQuery(this.bigQuery()).projectId(this.projectId).credentialsFile(this.credentialsFile).dataset(this.datasetName).logger(this.log).build();
        this.doExecute(bigQueryService);
    }

    private void enhanceClassloader() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            ArrayList streams = new ArrayList();
            streams.add(this.mavenProject.getRuntimeClasspathElements().stream());
            streams.add(this.mavenProject.getCompileClasspathElements().stream());
            streams.add(this.mavenProject.getTestClasspathElements().stream());
            for (String element : streams.stream().flatMap(s -> s).collect(Collectors.toList())) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new ConfigurationException(e.getMessage(), (Exception)e);
        }
    }

    private BigQuery bigQuery() {
        return (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)this.loadCredentials())).setProjectId(this.projectId)).build().getService();
    }

    private GoogleCredentials loadCredentials() {
        try {
            if (this.credentialsFile != null) {
                return ServiceAccountCredentials.fromStream((InputStream)this.loadResource(this.credentialsFile).getInputStream());
            }
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load credentials file " + this.credentialsFile, e);
        }
    }

    private Resource loadResource(String location) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        return resolver.getResource(location);
    }

    abstract void doExecute(BigQueryServiceImpl var1) throws MojoExecutionException;
}

