/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven;

import com.google.cloud.bigquery.BigQueryException;
import io.allune.bigquery.maven.AbstractBigQueryMojo;
import io.allune.bigquery.maven.service.BigQueryServiceImpl;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean")
public class CleanMojo
extends AbstractBigQueryMojo {
    @Parameter(alias="deleteDataset", property="bigquery.deleteDataset", defaultValue="false")
    private boolean deleteDataset;
    @Parameter(alias="deleteTables", property="bigquery.deleteTables", defaultValue="false")
    private boolean deleteTables;
    @Parameter(alias="forceDeleteDataset", property="bigquery.forceDeleteDataset", defaultValue="false")
    private boolean forceDeleteDataset;

    public void setDeleteDataset(boolean deleteDataset) {
        this.deleteDataset = deleteDataset;
    }

    public void setDeleteTables(boolean deleteTables) {
        this.deleteTables = deleteTables;
    }

    public void setForceDeleteDataset(boolean forceDeleteDataset) {
        this.forceDeleteDataset = forceDeleteDataset;
    }

    @Override
    protected void doExecute(BigQueryServiceImpl bigQueryService) throws MojoExecutionException {
        try {
            if (this.forceDeleteDataset) {
                bigQueryService.deleteDataset(true);
            } else {
                if (this.deleteTables) {
                    bigQueryService.deleteTables();
                }
                if (this.deleteDataset) {
                    bigQueryService.deleteDataset(false);
                }
            }
        }
        catch (BigQueryException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

