/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven;

import com.google.cloud.bigquery.BigQueryException;
import io.allune.bigquery.maven.AbstractBigQueryMojo;
import io.allune.bigquery.maven.ConfigurationException;
import io.allune.bigquery.maven.service.BigQueryServiceImpl;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create")
public class CreateMojo
extends AbstractBigQueryMojo {
    @Parameter(alias="nativeSchemaLocations", property="bigquery.nativeSchemaLocations")
    private String[] nativeSchemaLocations;
    @Parameter(alias="externalSchemaLocations", property="bigquery.externalSchemaLocations")
    private String[] externalSchemaLocations;
    @Parameter(alias="viewLocations", property="bigquery.viewLocations")
    private String[] viewLocations;
    @Parameter(property="bigquery.createDataset", defaultValue="true")
    private boolean createDataset;
    @Parameter(property="bigquery.sourceUri", defaultValue="gs://data.json")
    private String sourceUri;
    @Parameter(property="bigquery.formatOptions", defaultValue="NEWLINE_DELIMITED_JSON")
    private String formatOptions;

    public void setNativeSchemaLocations(String[] nativeSchemaLocations) {
        this.nativeSchemaLocations = nativeSchemaLocations;
    }

    public void setExternalSchemaLocations(String[] externalSchemaLocations) {
        this.externalSchemaLocations = externalSchemaLocations;
    }

    public void setViewLocations(String[] viewLocations) {
        this.viewLocations = viewLocations;
    }

    public void setCreateDataset(boolean createDataset) {
        this.createDataset = createDataset;
    }

    public void setSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
    }

    public void setFormatOptions(String formatOptions) {
        this.formatOptions = formatOptions;
    }

    @Override
    protected void doExecute(BigQueryServiceImpl bigQueryService) throws MojoExecutionException {
        try {
            if (this.createDataset) {
                bigQueryService.createDataset(this.getDataLocation());
            }
            if (ArrayUtils.isNotEmpty((Object[])this.nativeSchemaLocations)) {
                bigQueryService.createNativeTables(Arrays.asList(this.nativeSchemaLocations));
            }
            if (ArrayUtils.isNotEmpty((Object[])this.externalSchemaLocations)) {
                bigQueryService.createExternalTables(this.sourceUri, this.formatOptions, Arrays.asList(this.externalSchemaLocations));
            }
            if (ArrayUtils.isNotEmpty((Object[])this.viewLocations)) {
                bigQueryService.createViews(Arrays.asList(this.viewLocations));
            }
        }
        catch (BigQueryException | ConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

