/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven.config;

import io.allune.bigquery.maven.ConfigurationException;

public final class SchemaLocation
implements Comparable<SchemaLocation> {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILESYSTEM_PREFIX = "file:";
    private String prefix;
    private String path;

    SchemaLocation(String descriptor) {
        String normalizedDescriptor = descriptor.trim().replace("\\", "/");
        if (normalizedDescriptor.contains(":")) {
            this.prefix = normalizedDescriptor.substring(0, normalizedDescriptor.indexOf(58) + 1);
            this.path = normalizedDescriptor.substring(normalizedDescriptor.indexOf(58) + 1);
        } else {
            this.prefix = CLASSPATH_PREFIX;
            this.path = normalizedDescriptor;
        }
        if (this.isClassPath()) {
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
        } else if (!this.isFileSystem()) {
            throw new ConfigurationException("Unknown schema location prefix: " + normalizedDescriptor + ". file: or classpath: only supported");
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath() {
        return this.path;
    }

    boolean isClassPath() {
        return CLASSPATH_PREFIX.equals(this.prefix);
    }

    private boolean isFileSystem() {
        return FILESYSTEM_PREFIX.equals(this.prefix);
    }

    public boolean isParentOf(SchemaLocation other) {
        return (other.getDescriptor() + "/").startsWith(this.getDescriptor() + "/");
    }

    public String getDescriptor() {
        return this.prefix + this.path;
    }

    @Override
    public int compareTo(SchemaLocation o) {
        return this.getDescriptor().compareTo(o.getDescriptor());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaLocation schemaLocation = (SchemaLocation)o;
        return this.getDescriptor().equals(schemaLocation.getDescriptor());
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public String toString() {
        return this.getDescriptor();
    }
}

